/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.mime;

import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import ru.dlabs71.library.email.mime.FileParametersDetector;

public class DefaultFileParametersDetector
implements FileParametersDetector {
    private static final DefaultFileParametersDetector instance = new DefaultFileParametersDetector();
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";

    @Override
    public String detectMimeType(File file) {
        String contentType;
        try {
            contentType = Files.probeContentType(file.toPath());
        }
        catch (IOException e) {
            contentType = URLConnection.guessContentTypeFromName(file.getName());
        }
        return contentType != null ? contentType : DEFAULT_CONTENT_TYPE;
    }

    @Override
    public Charset detectEncoding(File file) {
        return Charset.defaultCharset();
    }

    public static DefaultFileParametersDetector getInstance() {
        return instance;
    }
}

