/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.property;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import ru.dlabs71.library.email.property.CommonProperties;
import ru.dlabs71.library.email.type.EncryptionType;

public class ImapProperties
extends CommonProperties {
    private String email;
    private String password;
    private boolean partialFetch = true;
    private int fetchSize = 0x100000;
    private int statusCacheTimeout = 1000;
    private int appendBufferSize = 1000;
    private int connectionPoolSize = 20;
    private int connectionPoolTimeout = 45000;

    public ImapProperties(String email, String password, boolean partialFetch, int fetchSize, int statusCacheTimeout, int appendBufferSize, int connectionPoolSize, int connectionPoolTimeout, String host, int port, EncryptionType encryptionType, int readTimeout, int connectionTimeout, int writeTimeout, boolean debug, Charset charset, Map<String, Object> extraProperties, int maxAttemptsOfRequest, int attemptDelayOfRequest) {
        super(host, port, encryptionType, readTimeout, connectionTimeout, writeTimeout, debug, charset, extraProperties, maxAttemptsOfRequest, attemptDelayOfRequest);
        this.email = email;
        this.password = password;
        this.partialFetch = partialFetch;
        this.fetchSize = fetchSize;
        this.statusCacheTimeout = statusCacheTimeout;
        this.appendBufferSize = appendBufferSize;
        this.connectionPoolSize = connectionPoolSize;
        this.connectionPoolTimeout = connectionPoolTimeout;
    }

    public static ImapPropertiesBuilder builder() {
        return new ImapPropertiesBuilder();
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isPartialFetch() {
        return this.partialFetch;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public int getStatusCacheTimeout() {
        return this.statusCacheTimeout;
    }

    public int getAppendBufferSize() {
        return this.appendBufferSize;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public int getConnectionPoolTimeout() {
        return this.connectionPoolTimeout;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPartialFetch(boolean partialFetch) {
        this.partialFetch = partialFetch;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setStatusCacheTimeout(int statusCacheTimeout) {
        this.statusCacheTimeout = statusCacheTimeout;
    }

    public void setAppendBufferSize(int appendBufferSize) {
        this.appendBufferSize = appendBufferSize;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public void setConnectionPoolTimeout(int connectionPoolTimeout) {
        this.connectionPoolTimeout = connectionPoolTimeout;
    }

    public ImapProperties() {
    }

    public static class ImapPropertiesBuilder {
        private String email;
        private String password;
        private boolean partialFetch = true;
        private int fetchSize = 0x100000;
        private int statusCacheTimeout = 1000;
        private int appendBufferSize = 1000;
        private int connectionPoolSize = 1;
        private int connectionPoolTimeout = 45000;
        private String host;
        private int port;
        private EncryptionType encryptionType = EncryptionType.NONE;
        private int readTimeout = 30000;
        private int connectionTimeout = 30000;
        private int writeTimeout = 30000;
        private boolean debug = false;
        private Charset charset = Charset.defaultCharset();
        private Map<String, Object> extraProperties = new HashMap<String, Object>();
        private int maxAttemptsOfRequest = 3;
        private int attemptDelayOfRequest = 0;

        public ImapProperties build() {
            return new ImapProperties(this.email, this.password, this.partialFetch, this.fetchSize, this.statusCacheTimeout, this.appendBufferSize, this.connectionPoolSize, this.connectionPoolTimeout, this.host, this.port, this.encryptionType, this.readTimeout, this.connectionTimeout, this.writeTimeout, this.debug, this.charset, this.extraProperties, this.maxAttemptsOfRequest, this.attemptDelayOfRequest);
        }

        public ImapPropertiesBuilder email(String email) {
            this.email = email;
            return this;
        }

        public ImapPropertiesBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ImapPropertiesBuilder partialFetch(boolean partialFetch) {
            this.partialFetch = partialFetch;
            return this;
        }

        public ImapPropertiesBuilder fetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public ImapPropertiesBuilder statusCacheTimeout(int statusCacheTimeout) {
            this.statusCacheTimeout = statusCacheTimeout;
            return this;
        }

        public ImapPropertiesBuilder appendBufferSize(int appendBufferSize) {
            this.appendBufferSize = appendBufferSize;
            return this;
        }

        public ImapPropertiesBuilder connectionPoolSize(int connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            return this;
        }

        public ImapPropertiesBuilder connectionPoolTimeout(int connectionPoolTimeout) {
            this.connectionPoolTimeout = connectionPoolTimeout;
            return this;
        }

        public ImapPropertiesBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ImapPropertiesBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ImapPropertiesBuilder encryptionType(EncryptionType encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        public ImapPropertiesBuilder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public ImapPropertiesBuilder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public ImapPropertiesBuilder writeTimeout(int writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public ImapPropertiesBuilder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public ImapPropertiesBuilder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public ImapPropertiesBuilder extraProperties(Map<String, Object> extraProperties) {
            this.extraProperties = extraProperties;
            return this;
        }

        public ImapPropertiesBuilder maxAttemptsOfRequest(int maxAttemptsOfRequest) {
            this.maxAttemptsOfRequest = maxAttemptsOfRequest;
            return this;
        }

        public ImapPropertiesBuilder attemptDelayOfRequest(int attemptDelayOfRequest) {
            this.attemptDelayOfRequest = attemptDelayOfRequest;
            return this;
        }

        public String toString() {
            return "ImapProperties.ImapPropertiesBuilder(email=" + this.email + ", password=" + this.password + ", partialFetch=" + this.partialFetch + ", fetchSize=" + this.fetchSize + ", statusCacheTimeout=" + this.statusCacheTimeout + ", appendBufferSize=" + this.appendBufferSize + ", connectionPoolSize=" + this.connectionPoolSize + ", connectionPoolTimeout=" + this.connectionPoolTimeout + ", host=" + this.host + ", port=" + this.port + ", encryptionType=" + (Object)((Object)this.encryptionType) + ", readTimeout=" + this.readTimeout + ", connectionTimeout=" + this.connectionTimeout + ", writeTimeout=" + this.writeTimeout + ", debug=" + this.debug + ", charset=" + this.charset + ", extraProperties=" + this.extraProperties + ", maxAttemptsOfRequest=" + this.maxAttemptsOfRequest + ", attemptDelayOfRequest=" + this.attemptDelayOfRequest + ")";
        }
    }
}

