/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.property;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Properties;
import org.eclipse.angus.mail.util.MailSSLSocketFactory;
import ru.dlabs71.library.email.property.CommonProperties;
import ru.dlabs71.library.email.type.EncryptionType;
import ru.dlabs71.library.email.type.Protocol;

public final class SessionPropertyCollector {
    public static Properties createCommonProperties(CommonProperties properties, Protocol protocol) throws GeneralSecurityException {
        Properties props = new Properties();
        props.put(SessionPropertyCollector.createProperty(protocol, "host"), properties.getHost());
        props.put(SessionPropertyCollector.createProperty(protocol, "port"), (Object)properties.getPort());
        props.put(SessionPropertyCollector.createProperty(protocol, "timeout"), (Object)properties.getReadTimeout());
        props.put(SessionPropertyCollector.createProperty(protocol, "connectiontimeout"), (Object)properties.getConnectionTimeout());
        props.put("mail.mime.allowutf8", (Object)true);
        props.put("mail.mime.charset", StandardCharsets.UTF_8.name());
        props.put("mail.debug", (Object)properties.isDebug());
        if (EncryptionType.SSL.equals((Object)properties.getEncryptionType())) {
            MailSSLSocketFactory sf = new MailSSLSocketFactory();
            props.put(SessionPropertyCollector.createProperty(protocol, "ssl.enable"), (Object)true);
            props.put(SessionPropertyCollector.createProperty(protocol, "socketFactory.port"), (Object)properties.getPort());
            props.put(SessionPropertyCollector.createProperty(protocol, "ssl.socketFactory"), sf);
            props.put(SessionPropertyCollector.createProperty(protocol, "ssl.checkserveridentity"), (Object)true);
        } else if (EncryptionType.TLS.equals((Object)properties.getEncryptionType())) {
            props.put(SessionPropertyCollector.createProperty(protocol, "starttls.enable"), (Object)true);
            props.put(SessionPropertyCollector.createProperty(protocol, "starttls.required"), (Object)true);
        }
        props.putAll(properties.getExtraProperties());
        return props;
    }

    public static String createProperty(Protocol protocol, String property) {
        return "mail." + protocol.getPropName() + "." + property;
    }
}

