/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.property;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import ru.dlabs71.library.email.property.CommonProperties;
import ru.dlabs71.library.email.type.EncryptionType;

public class SmtpProperties
extends CommonProperties {
    private String email;
    private String password;
    private String name;

    public SmtpProperties(String email, String password, String name, String host, int port, EncryptionType encryptionType, int readTimeout, int connectionTimeout, int writeTimeout, boolean debug, Charset charset, Map<String, Object> extraProperties, int maxAttemptsOfRequest, int attemptDelayOfRequest) {
        super(host, port, encryptionType, readTimeout, connectionTimeout, writeTimeout, debug, charset, extraProperties, maxAttemptsOfRequest, attemptDelayOfRequest);
        this.email = email;
        this.password = password;
        this.name = name;
    }

    public static SmtpPropertiesBuilder builder() {
        return new SmtpPropertiesBuilder();
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SmtpProperties() {
    }

    public static class SmtpPropertiesBuilder {
        private String email;
        private String password;
        private String name;
        private String host;
        private Integer port;
        private EncryptionType encryptionType = EncryptionType.NONE;
        private Integer readTimeout = 30000;
        private Integer connectionTimeout = 30000;
        private Integer writeTimeout = 30000;
        private boolean debug = false;
        private Charset charset = Charset.defaultCharset();
        private Map<String, Object> extraProperties = new HashMap<String, Object>();
        private int maxAttemptsOfRequest = 3;
        private int attemptDelayOfRequest = 0;

        public SmtpProperties build() {
            return new SmtpProperties(this.email, this.password, this.name, this.host, this.port, this.encryptionType, this.readTimeout, this.connectionTimeout, this.writeTimeout, this.debug, this.charset, this.extraProperties, this.maxAttemptsOfRequest, this.attemptDelayOfRequest);
        }

        public SmtpPropertiesBuilder email(String email) {
            this.email = email;
            return this;
        }

        public SmtpPropertiesBuilder password(String password) {
            this.password = password;
            return this;
        }

        public SmtpPropertiesBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SmtpPropertiesBuilder host(String host) {
            this.host = host;
            return this;
        }

        public SmtpPropertiesBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public SmtpPropertiesBuilder encryptionType(EncryptionType encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        public SmtpPropertiesBuilder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public SmtpPropertiesBuilder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public SmtpPropertiesBuilder writeTimeout(Integer writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public SmtpPropertiesBuilder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public SmtpPropertiesBuilder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public SmtpPropertiesBuilder extraProperties(Map<String, Object> extraProperties) {
            this.extraProperties = extraProperties;
            return this;
        }

        public SmtpPropertiesBuilder maxAttemptsOfRequest(int maxAttemptsOfRequest) {
            this.maxAttemptsOfRequest = maxAttemptsOfRequest;
            return this;
        }

        public SmtpPropertiesBuilder attemptDelayOfRequest(int attemptDelayOfRequest) {
            this.attemptDelayOfRequest = attemptDelayOfRequest;
            return this;
        }

        public String toString() {
            return "SmtpProperties.SmtpPropertiesBuilder(email=" + this.email + ", password=" + this.password + ", name=" + this.name + ", host=" + this.host + ", port=" + this.port + ", encryptionType=" + (Object)((Object)this.encryptionType) + ", readTimeout=" + this.readTimeout + ", connectionTimeout=" + this.connectionTimeout + ", writeTimeout=" + this.writeTimeout + ", debug=" + this.debug + ", charset=" + this.charset + ", extraProperties=" + this.extraProperties + ", maxAttemptsOfRequest=" + this.maxAttemptsOfRequest + ", attemptDelayOfRequest=" + this.attemptDelayOfRequest + ")";
        }
    }
}

