/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.type;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AttachmentType {
    IMAGE("image/.*"),
    VIDEO("video/.*"),
    AUDIO("audio/.*"),
    APPLICATION("application/.*"),
    FONT("font/.*"),
    MODEL("model/.*"),
    TEXT("text/.*"),
    UNKNOWN(null);

    private static final Logger log;
    private final String mimeTypePattern;

    private AttachmentType(String mimeTypePattern) {
        this.mimeTypePattern = mimeTypePattern;
    }

    public static AttachmentType find(String mimeType) {
        log.debug("Tries to look up the mime type in the AttachmentType. Mime type is {}", (Object)mimeType);
        return Arrays.stream(AttachmentType.values()).filter(item -> !item.equals((Object)UNKNOWN) && mimeType.matches(item.getMimeTypePattern())).findFirst().orElse(UNKNOWN);
    }

    public String getMimeTypePattern() {
        return this.mimeTypePattern;
    }

    static {
        log = LoggerFactory.getLogger(AttachmentType.class);
    }
}

