/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.type;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ContentMessageType {
    TEXT("text/plain"),
    HTML("text/html");

    private static final Logger log;
    private final String mimeType;

    private ContentMessageType(String mimeType) {
        this.mimeType = mimeType;
    }

    public static ContentMessageType forContentType(String contentType) {
        log.debug("Tries to look up the content type in the ContentMessageType. String content type is {}", (Object)contentType);
        if (contentType == null) {
            return null;
        }
        return Arrays.stream(ContentMessageType.values()).filter(item -> contentType.contains(item.getMimeType())).findFirst().orElse(null);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    static {
        log = LoggerFactory.getLogger(ContentMessageType.class);
    }
}

