/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.type;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TransferEncoder {
    SEVEN_BIT("7bit"),
    EIGHT_BIT("8bit"),
    BINARY("binary");

    private static final Logger log;
    private final String name;

    private TransferEncoder(String name) {
        this.name = name;
    }

    public static TransferEncoder byDefault() {
        return EIGHT_BIT;
    }

    public static TransferEncoder forName(String value) {
        log.debug("Tries to look up the Content Transfer Encoding in the TransferEncoder. Value is {}", (Object)value);
        if (value == null) {
            return null;
        }
        return Arrays.stream(TransferEncoder.values()).filter(item -> item.getName().equals(value)).findFirst().orElse(null);
    }

    public String getName() {
        return this.name;
    }

    static {
        log = LoggerFactory.getLogger(TransferEncoder.class);
    }
}

