/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.dlabs71.library.email.dto.message.common.EmailAttachment;
import ru.dlabs71.library.email.exception.AttachmentException;
import ru.dlabs71.library.email.mime.DefaultFileParametersDetector;
import ru.dlabs71.library.email.mime.FileParametersDetector;
import ru.dlabs71.library.email.type.AttachmentType;
import ru.dlabs71.library.email.util.FileSystemUtils;
import ru.dlabs71.library.email.util.JavaCoreUtils;
import ru.dlabs71.library.email.util.ProtocolUtils;

public final class AttachmentUtils {
    private static final Logger log = LoggerFactory.getLogger(AttachmentUtils.class);

    public static File createFile(String pathToFile) throws AttachmentException {
        pathToFile = pathToFile.trim();
        log.debug("Starts getting file for an attachment by path {}", (Object)pathToFile);
        try {
            URL url = null;
            if (pathToFile.startsWith("file://") || pathToFile.startsWith(File.separator)) {
                url = new URL(pathToFile);
            }
            if (pathToFile.startsWith("classpath:")) {
                pathToFile = pathToFile.replace("classpath:", "");
                url = AttachmentUtils.class.getClassLoader().getResource(pathToFile);
            }
            log.debug("Url is {}", (Object)url);
            if (url == null) {
                throw new AttachmentException("The resource cannot be loaded. The parameter pathToFile must start with a: 'file://'; 'classpath:' or '/'. The pathToFile = " + pathToFile);
            }
            File file = new File(url.toURI());
            if (!file.exists()) {
                throw new AttachmentException("File doesn't exist. The pathToFile = " + pathToFile);
            }
            return file;
        }
        catch (MalformedURLException | URISyntaxException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new AttachmentException("The resource cannot be loaded. The parameter pathToFile must start with a: 'file://'; 'classpath:' or '/'. The pathToFile = " + pathToFile + ". The error: " + ex.getMessage());
        }
    }

    public static EmailAttachment create(String pathToFile) throws AttachmentException {
        return AttachmentUtils.create(pathToFile, DefaultFileParametersDetector.getInstance());
    }

    public static EmailAttachment create(String pathToFile, FileParametersDetector detector) throws AttachmentException {
        byte[] content;
        File file = AttachmentUtils.createFile(pathToFile);
        log.debug("Creates attachment from the file {}", (Object)file);
        if (file.length() > Integer.MAX_VALUE) {
            throw new AttachmentException("The file is too large. A file cannot be larger than 2147483647. Filename = " + pathToFile);
        }
        String contentType = AttachmentUtils.createContentTypeForAttachment(file, detector);
        log.debug("Content type for file is {}", (Object)contentType);
        try {
            InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            content = JavaCoreUtils.toByteArray(inputStream);
        }
        catch (IOException ex) {
            throw new AttachmentException("Read the file was failed. " + ex.getMessage());
        }
        return EmailAttachment.builder().name(file.getName()).data(content).size((int)file.length()).contentType(contentType).type(AttachmentType.find(contentType)).build();
    }

    public static String createContentTypeForAttachment(File file) {
        return AttachmentUtils.createContentTypeForAttachment(file, null);
    }

    public static String createContentTypeForAttachment(File file, FileParametersDetector detector) {
        log.debug("Tries to create content type for file {} with using the detector is {}", (Object)file, (Object)detector);
        String mimeType = FileSystemUtils.detectFileMimeType(file, detector);
        log.debug("MIME type for the file {} is {}", (Object)file, (Object)mimeType);
        AttachmentType attachmentType = AttachmentType.find(mimeType);
        if (AttachmentType.TEXT.equals((Object)attachmentType)) {
            Charset encoding = FileSystemUtils.detectFileEncoding(file, detector);
            log.debug("Charset content of the file {} is {}", (Object)file, (Object)encoding);
            if (encoding != null) {
                return ProtocolUtils.contentTypeWithCharset(mimeType, encoding);
            }
        }
        return mimeType;
    }

    private AttachmentUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

