/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.util;

import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeUtility;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.dlabs71.library.email.dto.message.common.EmailParticipant;
import ru.dlabs71.library.email.util.ProtocolUtils;

public final class EmailMessageUtils {
    private static final Logger log = LoggerFactory.getLogger(EmailMessageUtils.class);

    public static InternetAddress createAddress(String email, String name) throws UnsupportedEncodingException, AddressException {
        String senderName = name == null ? email : name;
        log.debug("Creates instance of the InternetAddress class with email={} and name={}", (Object)email, (Object)senderName);
        InternetAddress address = new InternetAddress(email, senderName, ProtocolUtils.DEFAULT_ENCODING);
        address.validate();
        return address;
    }

    public static InternetAddress[] createAddresses(Set<EmailParticipant> recipients) {
        return (InternetAddress[])recipients.stream().map(recipient -> {
            try {
                return EmailMessageUtils.createAddress(recipient.getEmail(), recipient.getName());
            }
            catch (AddressException | UnsupportedEncodingException e) {
                log.error("Email address " + recipient + " is incorrect. " + e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).toArray(InternetAddress[]::new);
    }

    public static String decodeData(String data) {
        String decoded;
        log.debug("Tries to decode the data {}", (Object)data);
        if (data == null) {
            return null;
        }
        try {
            decoded = MimeUtility.decodeText((String)data);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("The data (" + data + ") doesn't decode by the following error: " + e.getMessage());
            decoded = data;
        }
        return Normalizer.normalize(decoded, Normalizer.Form.NFC);
    }

    private EmailMessageUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

