/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.util;

import java.io.File;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.dlabs71.library.email.mime.DefaultFileParametersDetector;
import ru.dlabs71.library.email.mime.FileParametersDetector;

public final class FileSystemUtils {
    private static final Logger log = LoggerFactory.getLogger(FileSystemUtils.class);

    public static Charset detectFileEncoding(File file) {
        return FileSystemUtils.detectFileEncoding(file, null);
    }

    public static Charset detectFileEncoding(File file, FileParametersDetector detector) {
        Charset encoding;
        log.debug("Tries to detect content encoding for file {}. Using detector is {}", (Object)file, (Object)detector);
        if (file == null || !file.exists()) {
            log.debug("An attempt to detect file content encoding failed because the file is null or doesn't exist");
            return null;
        }
        if (detector == null) {
            detector = DefaultFileParametersDetector.getInstance();
        }
        if ((encoding = detector.detectEncoding(file)) == null) {
            encoding = Charset.defaultCharset();
        }
        log.debug("File encoding is {}", (Object)encoding);
        return encoding;
    }

    public static String detectFileMimeType(File file) {
        return FileSystemUtils.detectFileMimeType(file, null);
    }

    public static String detectFileMimeType(File file, FileParametersDetector detector) {
        String mimeType;
        log.debug("Tries to detect MIME type for file {}. Using detector is {}", (Object)file, (Object)detector);
        if (file == null || !file.exists()) {
            log.debug("An attempt to detect file MINE type failed because the file is null or doesn't exist");
            return null;
        }
        if (detector == null) {
            detector = DefaultFileParametersDetector.getInstance();
        }
        if ((mimeType = detector.detectMimeType(file)) == null) {
            mimeType = "application/octet-stream";
        }
        log.debug("File MIME type is {}", (Object)mimeType);
        return mimeType;
    }

    private FileSystemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

