/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class JavaCoreUtils {
    public static byte[] toByteArray(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        return os.toByteArray();
    }

    public static LocalDateTime convert(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static void notNullArgument(Object object, String argName) {
        if (object == null) {
            throw new IllegalArgumentException(argName + "is marked non-null but is null");
        }
    }

    public static <T> Map<String, T> makeMap(String key, T value) {
        HashMap<String, T> map = new HashMap<String, T>();
        map.put(key, value);
        return map;
    }

    public static <T> Map<String, T> makeMap(String key1, T value1, String key2, T value2) {
        HashMap<String, T> map = new HashMap<String, T>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    private JavaCoreUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

