/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.util;

import ru.dlabs71.library.email.dto.message.common.Message;
import ru.dlabs71.library.email.exception.ValidationMessageException;

public final class MessageValidator {
    public static void validate(Message message) {
        if (message == null) {
            throw new ValidationMessageException("Email message cannot be null");
        }
        if (message.getRecipients() == null || message.getRecipients().isEmpty()) {
            throw new ValidationMessageException("List recipients cannot be null or empty in the email message");
        }
        if (message.getSubject() == null) {
            throw new ValidationMessageException("Subject cannot be null in the email message");
        }
        if (message.getContents() == null || message.getContents().isEmpty()) {
            throw new ValidationMessageException("Content cannot be null in the email message");
        }
    }

    private MessageValidator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

