/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtocolUtils {
    private static final Logger log = LoggerFactory.getLogger(ProtocolUtils.class);
    public static final String CONTENT_TYPE_HDR = "Content-type";
    public static final String CONTENT_TRANSFER_ENCODING_HDR = "Content-Transfer-Encoding";
    public static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    public static final String TEXT_CONTENT_TYPE = "text/plain";
    public static final String HTML_CONTENT_TYPE = "text/html";
    public static final String DEFAULT_BINARY_CONTENT_TYPE = "application/octet-stream";

    public static String contentTypeWithCharset(String contentType, Charset charset) {
        return ProtocolUtils.contentTypeWithCharset(contentType, charset.displayName());
    }

    public static String contentTypeWithCharset(String contentType, String charset) {
        if (contentType.contains("charset")) {
            return contentType;
        }
        if (charset == null) {
            return contentType;
        }
        return contentType + "; charset=" + charset.toLowerCase();
    }

    public static String contentTypeWithCharset(String contentType) {
        return ProtocolUtils.contentTypeWithCharset(contentType, DEFAULT_ENCODING);
    }

    public static String defineCharsetFromHeaderValue(String contentTypeValue) {
        log.debug("Tries to detect value of the charset directive form the content type header value. The header value is {}", (Object)contentTypeValue);
        if (contentTypeValue == null || contentTypeValue.isEmpty()) {
            return null;
        }
        if (contentTypeValue.contains("charset")) {
            String value = contentTypeValue.split("charset")[1].replaceAll("\\s", "").replaceFirst("=", "").trim();
            value = value.split(";")[0];
            log.debug("Charset for content type {} is {}", (Object)contentTypeValue, (Object)value);
            return value;
        }
        log.debug("Charset for content type {} is null", (Object)contentTypeValue);
        return null;
    }

    private ProtocolUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

