/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.util;

import jakarta.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryableUtils {
    private static final Logger log = LoggerFactory.getLogger(RetryableUtils.class);

    public static <R> R retry(int count, long delayInMs, RetryableSupplier<R> supplier) throws MessagingException {
        while (true) {
            try {
                return supplier.get();
            }
            catch (MessagingException ex) {
                MessagingException messagingException = ex;
                log.warn(ex.getMessage());
                if (delayInMs != 0L) {
                    log.info("Start delay");
                    try {
                        Thread.sleep(delayInMs);
                    }
                    catch (InterruptedException e) {
                        log.error("Error in delay: " + e.getMessage());
                    }
                }
                log.info("Repeat request. Count = " + count);
                if (count-- != 0) continue;
                throw messagingException;
            }
            break;
        }
    }

    public static void retry(int count, long delayInMs, RetryableWorker worker) throws MessagingException {
        RetryableUtils.retry(count, delayInMs, () -> {
            worker.work();
            return null;
        });
    }

    private RetryableUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface RetryableWorker {
        public void work() throws MessagingException;
    }

    @FunctionalInterface
    public static interface RetryableSupplier<R> {
        public R get() throws MessagingException;
    }
}

