/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.util;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.apache.velocity.runtime.resource.loader.JarResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.dlabs71.library.email.exception.TemplateCreationException;

public final class TemplateUtils {
    private static final Logger log = LoggerFactory.getLogger(TemplateUtils.class);

    public static String construct(String pathToTemplate, Map<String, Object> params) throws TemplateCreationException {
        Template template = TemplateUtils.createTemplate(pathToTemplate);
        return TemplateUtils.construct(template, params);
    }

    public static String construct(Template template, Map<String, Object> params) {
        VelocityContext context = new VelocityContext(params);
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    public static Template createTemplate(String pathToTemplate) throws TemplateCreationException {
        if (pathToTemplate.startsWith("file://")) {
            return TemplateUtils.createFileTemplate(pathToTemplate);
        }
        if (pathToTemplate.startsWith("classpath:")) {
            return TemplateUtils.createClasspathTemplate(pathToTemplate);
        }
        if (pathToTemplate.startsWith("jar:file:")) {
            return TemplateUtils.createJarFileTemplate(pathToTemplate);
        }
        throw new TemplateCreationException("Template path must starts with 'file://', 'classpath:' or 'jar:file:'. It's using template path: " + pathToTemplate);
    }

    public static Template createClasspathTemplate(String pathTemplate) {
        log.debug("A template will create from classpath source using the path equal to {}", (Object)pathTemplate);
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("resource.loaders", (Object)"classpath");
        velocityEngine.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        velocityEngine.init();
        TemplatePath templatePath = TemplateUtils.normalizeTemplatePath(pathTemplate);
        return velocityEngine.getTemplate(templatePath.getFullPath(), StandardCharsets.UTF_8.name());
    }

    public static Template createFileTemplate(String pathTemplate) {
        log.debug("A template will create from file system source using the path equal to {}", (Object)pathTemplate);
        VelocityEngine velocityEngine = new VelocityEngine();
        TemplatePath templatePath = TemplateUtils.normalizeTemplatePath(pathTemplate);
        velocityEngine.setProperty("resource.loaders", (Object)"file");
        velocityEngine.setProperty("resource.loader.file.class", (Object)FileResourceLoader.class.getName());
        velocityEngine.setProperty("resource.loader.file.path", (Object)templatePath.getPathToDir());
        velocityEngine.setProperty("resource.loader.file.cache", (Object)false);
        velocityEngine.setProperty("resource.loader.file.modification_check_interval", (Object)0);
        velocityEngine.init();
        return velocityEngine.getTemplate(templatePath.getTemplateName(), StandardCharsets.UTF_8.name());
    }

    public static Template createJarFileTemplate(String pathTemplate) {
        log.debug("A template will create from jar using the path equal to {}", (Object)pathTemplate);
        VelocityEngine velocityEngine = new VelocityEngine();
        TemplatePath templatePath = TemplateUtils.normalizeTemplatePath(pathTemplate);
        velocityEngine.setProperty("resource.loaders", (Object)"jar");
        velocityEngine.setProperty("resource.loader.jar.class", (Object)JarResourceLoader.class.getName());
        velocityEngine.setProperty("resource.loader.jar.path", (Object)templatePath.getPathToDir());
        velocityEngine.init();
        return velocityEngine.getTemplate(templatePath.getTemplateName(), StandardCharsets.UTF_8.name());
    }

    public static TemplatePath normalizeTemplatePath(String source) {
        log.debug("Starts template path normalizing for {}", (Object)source);
        if (source.startsWith("file://")) {
            source = source.replace("file://", "");
        }
        if (source.startsWith("classpath:")) {
            source = source.replace("classpath:", "");
        }
        if (source.startsWith("jar:file:")) {
            String[] parts = source.split("!");
            return new TemplatePath(parts[1], parts[0]);
        }
        log.debug("Normalized path is {}", (Object)source);
        source = Paths.get(source, new String[0]).toString();
        if (!source.contains(File.separator)) {
            return new TemplatePath(source, "");
        }
        return TemplateUtils.createTemplatePath(source);
    }

    private static TemplatePath createTemplatePath(String source) {
        log.debug("Starts creating instance of the TemplatePath class for {}", (Object)source);
        String[] paths = source.split("[\\\\/]");
        CharSequence[] pathToDirectory = Arrays.copyOf(paths, paths.length - 1);
        String filename = paths[paths.length - 1];
        log.debug("Create a TemplatePath from filename={} and pathToDirectory={}", (Object)filename, (Object)pathToDirectory);
        return new TemplatePath(filename, String.join((CharSequence)File.separator, pathToDirectory));
    }

    private TemplateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class TemplatePath {
        private final String templateName;
        private final String pathToDir;

        public String getFullPath() {
            return this.pathToDir + File.separator + this.templateName;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public String getPathToDir() {
            return this.pathToDir;
        }

        public TemplatePath(String templateName, String pathToDir) {
            this.templateName = templateName;
            this.pathToDir = pathToDir;
        }
    }
}

