/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.controller;

import com.dnlkk.controller.ControllerRegistry;
import com.dnlkk.controller.annotations.Get;
import com.dnlkk.controller.annotations.Post;
import com.dnlkk.controller.annotations.RequestMapping;
import com.dnlkk.controller.responses.ResponseEntity;
import com.dnlkk.util.ControllerUtils;
import com.dnlkk.util.PathUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherServlet
extends HttpServlet {
    private final ControllerRegistry controllerRegistry = new ControllerRegistry();
    private static final Logger logger = LoggerFactory.getLogger(DispatcherServlet.class);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map parameterMap = request.getParameterMap();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=UTF-8");
        String path = request.getPathInfo();
        if (path == null || !this.dispatch(response, request, parameterMap)) {
            response.setStatus(404);
            response.getWriter().write("{\"error\": \"\u0420\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!\"}");
        }
    }

    public boolean dispatch(HttpServletResponse response, HttpServletRequest request, Map<String, String[]> parametersMap) {
        String path = request.getPathInfo();
        Optional<Map.Entry> optionalEntryMapController = this.controllerRegistry.getControllers().entrySet().stream().filter(entryMapController -> path.startsWith((String)entryMapController.getKey())).findFirst();
        if (optionalEntryMapController.isEmpty()) {
            return false;
        }
        Map.Entry entryMapController2 = optionalEntryMapController.get();
        String methodPath = ((String)entryMapController2.getKey()).length() == path.length() ? "/" : path.substring(((String)entryMapController2.getKey()).length());
        Object controller = entryMapController2.getValue();
        if (controller != null) {
            return !Arrays.stream(controller.getClass().getDeclaredMethods()).filter(controllerEndpoint -> {
                String requestMapping = this.getRequestMapping((Method)controllerEndpoint);
                if (requestMapping == null) {
                    return false;
                }
                if (PathUtils.isRequestMapping(methodPath, requestMapping)) {
                    if (ControllerUtils.methodEquals(controllerEndpoint, Get.class, request.getMethod())) {
                        return false;
                    }
                    if (ControllerUtils.methodEquals(controllerEndpoint, Post.class, request.getMethod())) {
                        return false;
                    }
                    try {
                        String body = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
                        List<Object> parameters = ControllerUtils.getParametersFromRequest(controllerEndpoint, methodPath, requestMapping, parametersMap, body);
                        Object controllerReturn = controllerEndpoint.invoke(controller, parameters.toArray());
                        if (controllerReturn.getClass().equals(ResponseEntity.class)) {
                            ResponseEntity responseEntity = (ResponseEntity)controllerReturn;
                            response.setStatus(responseEntity.getStatus().code());
                            response.getWriter().write(responseEntity.json());
                        } else if (controllerReturn.getClass().equals(String.class)) {
                            response.getWriter().write(controllerReturn.toString());
                        } else {
                            return false;
                        }
                        return true;
                    }
                    catch (IOException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        logger.error(e.getMessage());
                    }
                }
                return false;
            }).toList().isEmpty();
        }
        return false;
    }

    private String getRequestMapping(Method controllerEndpoint) {
        if (controllerEndpoint.isAnnotationPresent(RequestMapping.class)) {
            return controllerEndpoint.getAnnotation(RequestMapping.class).value();
        }
        return null;
    }

    public ControllerRegistry getControllerRegistry() {
        return this.controllerRegistry;
    }
}

