/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.controller;

import com.dnlkk.boot.AppConfig;
import com.dnlkk.controller.DispatcherServlet;
import jakarta.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Tomcat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontController {
    private final Logger logger = LoggerFactory.getLogger(FrontController.class);
    private final DispatcherServlet dispatcherServlet;
    private Tomcat tomcat;

    public FrontController(DispatcherServlet dispatcherServlet) {
        this.dispatcherServlet = dispatcherServlet;
        System.out.println("in front controller!");
        System.out.println(this.dispatcherServlet.getControllerRegistry().getControllers());
        System.out.println(dispatcherServlet.getControllerRegistry().getControllers());
        Tomcat tomcat = new Tomcat();
        String portProperty = AppConfig.getProperty("app.port");
        Integer port = portProperty == null ? 8080 : Integer.parseInt(portProperty);
        String hostname = AppConfig.getProperty("app.hostname");
        tomcat.setPort(port.intValue());
        tomcat.setHostname(hostname != null ? hostname : "localhost");
        Context context = tomcat.addContext("", null);
        Tomcat.addServlet((Context)context, (String)"DispatcherServlet", (Servlet)this.dispatcherServlet);
        context.addServletMappingDecoded("/*", "DispatcherServlet");
        this.tomcat = tomcat;
        this.tomcat.getConnector();
        try {
            this.tomcat.start();
        }
        catch (LifecycleException e) {
            e.printStackTrace();
        }
        this.tomcat.getServer().await();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public DispatcherServlet getDispatcherServlet() {
        return this.dispatcherServlet;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public void setTomcat(Tomcat tomcat) {
        this.tomcat = tomcat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FrontController)) {
            return false;
        }
        FrontController other = (FrontController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        DispatcherServlet this$dispatcherServlet = this.getDispatcherServlet();
        DispatcherServlet other$dispatcherServlet = other.getDispatcherServlet();
        if (this$dispatcherServlet == null ? other$dispatcherServlet != null : !((Object)((Object)this$dispatcherServlet)).equals((Object)other$dispatcherServlet)) {
            return false;
        }
        Tomcat this$tomcat = this.getTomcat();
        Tomcat other$tomcat = other.getTomcat();
        return !(this$tomcat == null ? other$tomcat != null : !this$tomcat.equals(other$tomcat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FrontController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        DispatcherServlet $dispatcherServlet = this.getDispatcherServlet();
        result = result * 59 + ($dispatcherServlet == null ? 43 : ((Object)((Object)$dispatcherServlet)).hashCode());
        Tomcat $tomcat = this.getTomcat();
        result = result * 59 + ($tomcat == null ? 43 : $tomcat.hashCode());
        return result;
    }

    public String toString() {
        return "FrontController(logger=" + this.getLogger() + ", dispatcherServlet=" + this.getDispatcherServlet() + ", tomcat=" + this.getTomcat() + ")";
    }
}

