/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.boot;

import com.dnlkk.util.PathUtils;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class AppConfig {
    private static Map<String, Object> baseConfig;
    private static Map<String, Object> config;
    private static final Logger logger;

    public static boolean configIsLoaded() {
        return config != null;
    }

    public static String getBaseProperty(String key) {
        if (baseConfig == null) {
            AppConfig.loadBaseConfig();
        }
        return AppConfig.findProperty(baseConfig, key);
    }

    public static String getProperty(String key) {
        if (config == null) {
            AppConfig.loadConfig(AppConfig.class);
        }
        return AppConfig.findProperty(config, key);
    }

    private static String findProperty(Map<String, Object> config, String key) {
        if (config == null) {
            return null;
        }
        if (config.containsKey(key)) {
            return config.get(key).toString();
        }
        String[] keys = PathUtils.splitPath("\\.", key);
        String nextKey = PathUtils.removeFirstPath(".", keys);
        if (nextKey == null) {
            return null;
        }
        return AppConfig.findProperty((Map)config.get(keys[0]), nextKey);
    }

    public static boolean loadBaseConfig() {
        boolean bl;
        block9: {
            Yaml yaml = new Yaml();
            if (baseConfig != null) {
                return true;
            }
            InputStream inputStream = AppConfig.class.getClassLoader().getResourceAsStream("base_application.yml");
            try {
                baseConfig = (Map)yaml.load(inputStream);
                boolean bl2 = bl = baseConfig != null;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("base_application.yml config in resources not found");
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    public static boolean loadConfig(Class<?> clazz) {
        boolean bl;
        block9: {
            Yaml yaml = new Yaml();
            if (config != null) {
                return true;
            }
            InputStream inputStream = (clazz == null ? AppConfig.class : clazz).getClassLoader().getResourceAsStream("application.yml");
            try {
                config = (Map)yaml.load(inputStream);
                boolean bl2 = bl = config != null;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("application.yml config in resources not found");
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    static {
        logger = LoggerFactory.getLogger(AppConfig.class);
    }
}

