/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.repository;

import com.dnlkk.repository.QueryOperation;
import com.dnlkk.repository.annotations.entity.ManyToOne;
import com.dnlkk.repository.annotations.entity.OneToOne;
import com.dnlkk.repository.annotations.entity.Table;
import com.dnlkk.util.EntityUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryGenerator {
    private static final Logger logger = LoggerFactory.getLogger(QueryGenerator.class);

    public static String generateQuery(Method method, String tableName, Class<?> valueClass, List<Field> references) {
        String methodName = method.getName();
        Object[] methodParts = methodName.split("(?=[A-Z])");
        StringBuilder query = new StringBuilder("");
        logger.debug(Arrays.toString(methodParts));
        if (methodParts.length > 0) {
            if (((String)methodParts[0]).equals(QueryOperation.FIND.getValue())) {
                query.append("SELECT * ");
            } else if (((String)methodParts[0]).equals(QueryOperation.COUNT.getValue())) {
                query.append("SELECT COUNT( DISTINCT " + EntityUtils.getRelationIdFieldName(valueClass) + " ) ");
            } else if (((String)methodParts[0]).equals(QueryOperation.SUM.getValue())) {
                query.append("SELECT SUM( DISTINCT " + ((String)methodParts[1]).toLowerCase() + ") ");
            }
            query.append("FROM " + tableName);
            boolean whereClauseAdded = false;
            query.append(QueryGenerator.getReferencesJoin(references, tableName));
            Field[] fields = valueClass.getDeclaredFields();
            for (int i = 0; i < methodParts.length; ++i) {
                List<Field> list;
                String part = ((String)methodParts[i]).toLowerCase();
                if (part.equals("all")) continue;
                if (part.equals("by")) {
                    if (!whereClauseAdded) {
                        query.append(" WHERE");
                        whereClauseAdded = true;
                    }
                } else if (part.equals("or")) {
                    query.append(" OR");
                } else if (part.equals("and")) {
                    query.append(" AND");
                }
                if (!whereClauseAdded || (list = Arrays.stream(fields).filter(field -> field.getName().toLowerCase().equals(part)).toList()).isEmpty()) continue;
                int methodParameterIndex = Arrays.stream(fields).toList().indexOf(list.get(0));
                String paramName = valueClass.getDeclaredFields()[methodParameterIndex].getName();
                query.append(" " + tableName + "." + paramName + " = ? ");
            }
            String resultQuery = query.toString();
            logger.debug(resultQuery);
            return resultQuery;
        }
        return null;
    }

    public static String getReferencesJoin(List<Field> references, String tableName) {
        StringBuilder builder = new StringBuilder(" ");
        ArrayList<String> includedTableNames = new ArrayList<String>();
        if (!references.isEmpty()) {
            String sourceKey = EntityUtils.getColumnName(EntityUtils.getIdField(references.get(0).getDeclaringClass()));
            for (Field field : references) {
                Class targetClass = null;
                targetClass = field.getType() == List.class ? (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] : (Class)field.getGenericType();
                String targetTableName = targetClass.getAnnotation(Table.class).value();
                if (includedTableNames.contains(targetTableName)) continue;
                String targetKey = null;
                for (Field targetField : targetClass.getDeclaredFields()) {
                    if ((!targetField.isAnnotationPresent(OneToOne.class) || !targetField.getAnnotation(OneToOne.class).value().equals(field.getName())) && (!targetField.isAnnotationPresent(ManyToOne.class) || !targetField.getAnnotation(ManyToOne.class).value().equals(field.getName()))) continue;
                    targetKey = EntityUtils.getColumnName(targetField);
                }
                if (targetKey == null) continue;
                builder.append("LEFT JOIN " + targetTableName + " ON " + tableName + "." + sourceKey + " = " + targetTableName + "." + targetKey + " ");
                includedTableNames.add(targetTableName);
            }
        }
        return builder.toString();
    }
}

