/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk;

import com.dnlkk.boot.AppConfig;
import com.dnlkk.boot.Banner;
import com.dnlkk.boot.annotations.DnlkkApp;
import com.dnlkk.boot.annotations.DnlkkWeb;
import com.dnlkk.controller.DispatcherServlet;
import com.dnlkk.controller.FrontController;
import com.dnlkk.dependency_injector.annotation_context.AnnotationApplicationContext;
import com.dnlkk.dependency_injector.annotations.components.RestController;
import com.dnlkk.dependency_injector.application_context.ApplicationContext;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnlkkApplication {
    private boolean isApplicationConfigLoaded;
    private String banner = null;
    private Class<?> primarySource;
    private Class<? extends ApplicationContext> applicationContextClass;
    private final Logger logger = LoggerFactory.getLogger(DnlkkApplication.class);

    public static Object run(Class<?> clazz, String[] args) {
        return new DnlkkApplication(clazz).run(args);
    }

    private Object run(String[] args) {
        try {
            Object app = this.primarySource.getConstructor(new Class[0]).newInstance(new Object[0]);
            ApplicationContext applicationContext = this.applicationContextClass.getConstructor(Object.class).newInstance(app);
            if (this.primarySource.isAnnotationPresent(DnlkkWeb.class)) {
                DispatcherServlet dispatcherServlet = new DispatcherServlet();
                applicationContext.getComponents().values().forEach(component -> {
                    if (component.getClass().isAnnotationPresent(RestController.class)) {
                        dispatcherServlet.getControllerRegistry().registerController(component.getClass().getAnnotation(RestController.class).value(), component);
                    }
                });
                new FrontController(dispatcherServlet);
            }
            return this.primarySource.cast(app);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.error("Project initialize failed! Exit...");
            System.exit(-1);
            return null;
        }
    }

    public DnlkkApplication(Class<?> clazz) {
        this.isApplicationConfigLoaded = AppConfig.loadConfig(clazz);
        try {
            this.banner = Banner.init(clazz);
        }
        catch (Exception e) {
            this.banner = Banner.init(null);
        }
        if (this.banner != null) {
            System.out.println(this.banner);
        }
        this.primarySource = clazz;
        this.applicationContextClass = AnnotationApplicationContext.class;
        if (clazz.isAnnotationPresent(DnlkkWeb.class)) {
            this.applicationContextClass = AnnotationApplicationContext.class;
        } else if (clazz.getAnnotations().length == 0 || clazz.isAnnotationPresent(DnlkkApp.class)) {
            this.applicationContextClass = AnnotationApplicationContext.class;
        }
    }
}

