/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.controller.responses;

import com.dnlkk.controller.http.HttpStatus;
import com.dnlkk.util.EntityUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;

public class ResponseEntity<T> {
    private final Map<String, String> httpHeaders;
    private final T body;
    private final HttpStatus status;

    public String json() {
        try {
            return EntityUtils.objectMapper.writeValueAsString(this.body);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public ResponseEntity() {
        this(null, null, HttpStatus.OK);
    }

    public ResponseEntity(T body) {
        this(body, null, HttpStatus.OK);
    }

    public ResponseEntity(Map<String, String> headers) {
        this(null, headers);
    }

    public ResponseEntity(T body, Map<String, String> headers) {
        this.body = body;
        this.httpHeaders = headers != null ? headers : new HashMap();
        this.status = HttpStatus.OK;
    }

    public ResponseEntity(T body, HttpStatus httpStatus) {
        this(body, null, httpStatus);
    }

    public ResponseEntity(Map<String, String> headers, HttpStatus httpStatus) {
        this(null, headers, httpStatus);
    }

    public ResponseEntity(T body, Map<String, String> headers, HttpStatus httpStatus) {
        this.body = body;
        this.httpHeaders = headers != null ? headers : new HashMap();
        this.status = httpStatus;
    }

    public static <T> ResponseEntity<T> ok(T body) {
        return new ResponseEntity<T>(body, HttpStatus.OK);
    }

    public static <T> ResponseEntity<T> noContent(T body) {
        return new ResponseEntity<T>(body, HttpStatus.NO_CONTENT);
    }

    public static <T> ResponseEntity<T> bad(T body) {
        return new ResponseEntity<T>(body, HttpStatus.BAD_REQUEST);
    }

    public static <T> ResponseEntity<T> notFound(T body) {
        return new ResponseEntity<T>(body, HttpStatus.NOT_FOUND);
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public T getBody() {
        return this.body;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseEntity)) {
            return false;
        }
        ResponseEntity other = (ResponseEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$httpHeaders = this.getHttpHeaders();
        Map<String, String> other$httpHeaders = other.getHttpHeaders();
        if (this$httpHeaders == null ? other$httpHeaders != null : !((Object)this$httpHeaders).equals(other$httpHeaders)) {
            return false;
        }
        T this$body = this.getBody();
        T other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        HttpStatus this$status = this.getStatus();
        HttpStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $httpHeaders = this.getHttpHeaders();
        result = result * 59 + ($httpHeaders == null ? 43 : ((Object)$httpHeaders).hashCode());
        T $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        HttpStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseEntity(httpHeaders=" + this.getHttpHeaders() + ", body=" + this.getBody() + ", status=" + this.getStatus() + ")";
    }
}

