/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.dependency_injector.annotation_context;

import com.dnlkk.dependency_injector.application_context.PeaFactory;
import com.dnlkk.dependency_injector.config.PeaObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class AnnotationPeaFactory
implements PeaFactory {
    private Map<String, PeaObject> peas = new HashMap<String, PeaObject>();

    @Override
    public <V> void setPeas(Map<String, V> peas) {
        this.peas = peas;
    }

    @Override
    public <T> T getPrototypePea(Class<T> componentClass, String name) {
        if (this.peas.containsKey(name)) {
            PeaObject peaObject = this.peas.get(name);
            return componentClass.cast(this.invokePeaMethod(peaObject.getConfigInstance(), peaObject.getInvokeMethod()));
        }
        return null;
    }

    @Override
    public <T> T getPrototypePea(Class<T> componentClass) {
        for (PeaObject peaObject : this.peas.values()) {
            if (peaObject.getSingleton().getClass() != componentClass) continue;
            return componentClass.cast(this.invokePeaMethod(peaObject.getConfigInstance(), peaObject.getInvokeMethod()));
        }
        return null;
    }

    @Override
    public <T> T getSingletonPea(Class<T> componentClass, String name) {
        if (this.peas.containsKey(name)) {
            return componentClass.cast(this.peas.get(name).getSingleton());
        }
        return null;
    }

    @Override
    public <T> T getSingletonPea(Class<T> componentClass) {
        for (PeaObject peaObject : this.peas.values()) {
            if (peaObject.getSingleton().getClass() != componentClass) continue;
            return componentClass.cast(peaObject.getSingleton());
        }
        return null;
    }

    private Object invokePeaMethod(Object configInstance, Method method) {
        try {
            return method.invoke(configInstance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to invoke Pea method " + method.getName());
        }
    }

    public Map<String, PeaObject> getPeas() {
        return this.peas;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotationPeaFactory)) {
            return false;
        }
        AnnotationPeaFactory other = (AnnotationPeaFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, PeaObject> this$peas = this.getPeas();
        Map<String, PeaObject> other$peas = other.getPeas();
        return !(this$peas == null ? other$peas != null : !((Object)this$peas).equals(other$peas));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnnotationPeaFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, PeaObject> $peas = this.getPeas();
        result = result * 59 + ($peas == null ? 43 : ((Object)$peas).hashCode());
        return result;
    }

    public String toString() {
        return "AnnotationPeaFactory(peas=" + this.getPeas() + ")";
    }
}

