/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.repository;

import com.dnlkk.dependency_injector.DependencyInjector;
import com.dnlkk.repository.QueryGenerator;
import com.dnlkk.repository.QueryOperation;
import com.dnlkk.repository.annotations.Param;
import com.dnlkk.repository.annotations.Query;
import com.dnlkk.repository.annotations.entity.ManyToMany;
import com.dnlkk.repository.annotations.entity.ManyToOne;
import com.dnlkk.repository.annotations.entity.OneToMany;
import com.dnlkk.repository.annotations.entity.OneToOne;
import com.dnlkk.repository.dnlkk_connection_pool.DnlkkDataSourceFactory;
import com.dnlkk.util.EntityUtils;
import com.dnlkk.util.SQLQueryUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryProxyHandler
implements InvocationHandler {
    private final DataSource dataSource;
    private String tableName;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private Class<?> repositoryInterface;
    private List<Field> references;
    private final Logger logger = LoggerFactory.getLogger(RepositoryProxyHandler.class);

    public RepositoryProxyHandler(Class<?> clazz) {
        this.repositoryInterface = clazz;
        this.dataSource = DnlkkDataSourceFactory.createDataSource();
        this.references = new ArrayList<Field>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        if (method.isAnnotationPresent(Query.class)) {
            result = this.executeCustomQuery(method.getAnnotation(Query.class).value(), args, method.getParameters());
        } else if (method.getName().startsWith(QueryOperation.FIND.getValue())) {
            result = this.executeFindQuery(method, args);
        } else if (method.getName().startsWith(QueryOperation.COUNT.getValue()) || method.getName().startsWith(QueryOperation.SUM.getValue())) {
            result = this.executeCountQuery(method, args);
        } else if (method.getName().equals(QueryOperation.SAVE.getValue())) {
            result = this.saveEntity(args[0]);
        }
        if (result != null && !List.class.isAssignableFrom(method.getReturnType()) && List.class.isAssignableFrom(result.getClass())) {
            result = ((List)result).size() > 0 ? ((List)result).get(0) : null;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Object> statementListExecutor(PreparedStatement statement) throws SQLException {
        ArrayList<Object> resultFunction = new ArrayList<Object>();
        Object id = null;
        boolean idChange = false;
        HashMap oneToMany = new HashMap();
        HashMap entityToIdMap = new HashMap();
        Object entity = null;
        Field[] fields = null;
        try {
            entity = this.valueClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            fields = this.valueClass.getDeclaredFields();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        try (ResultSet resultSet = statement.executeQuery();){
            block9: while (resultSet.next()) {
                try {
                    Field[] fieldArray = fields;
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (true) {
                        block31: {
                            int n3;
                            Field[] fieldArray2;
                            Object relationFromId;
                            Object relationEntity;
                            Field field;
                            block32: {
                                block29: {
                                    block30: {
                                        if (n2 >= n) break block29;
                                        field = fieldArray[n2];
                                        if (!EntityUtils.isNotPK(field)) {
                                            Object newId = resultSet.getObject(EntityUtils.getColumnName(field));
                                            if (id == null || !id.equals(newId)) {
                                                id = newId;
                                                idChange = true;
                                                if (entityToIdMap.containsKey(id)) {
                                                    entity = entityToIdMap.get(id);
                                                } else {
                                                    entity = this.valueClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                                    entityToIdMap.put(id, entity);
                                                }
                                                for (Field field2 : fields) {
                                                    if (EntityUtils.isNotRelation(field2) || oneToMany.get(String.format("%s%s", id.toString(), field2.getName())) != null || field2.isAnnotationPresent(OneToOne.class)) continue;
                                                    oneToMany.put(String.format("%s%s", id.toString(), field2.getName()), new ArrayList());
                                                }
                                            } else {
                                                idChange = false;
                                            }
                                        }
                                        if (!EntityUtils.isNotRelation(field)) break block30;
                                        Object retrievedObject = resultSet.getObject(EntityUtils.getColumnName(field));
                                        DependencyInjector.setField(entity, retrievedObject, field);
                                        break block31;
                                    }
                                    if (!field.isAnnotationPresent(OneToMany.class) && !field.isAnnotationPresent(ManyToMany.class) && !field.isAnnotationPresent(OneToOne.class)) break block31;
                                    Class relationClazz = null;
                                    relationClazz = field.isAnnotationPresent(OneToOne.class) ? field.getType() : (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                                    relationEntity = relationClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                    relationFromId = null;
                                    fieldArray2 = relationClazz.getDeclaredFields();
                                    n3 = fieldArray2.length;
                                    break block32;
                                }
                                if (!idChange) continue block9;
                                resultFunction.add(entity);
                            }
                            for (int i = 0; i < n3; ++i) {
                                Field relationField = fieldArray2[i];
                                if (EntityUtils.isNotRelation(relationField)) {
                                    Object retrievedObject = resultSet.getObject(EntityUtils.getColumnName(relationField));
                                    DependencyInjector.setField(relationEntity, retrievedObject, relationField);
                                    continue;
                                }
                                if (!relationField.isAnnotationPresent(ManyToOne.class) && !field.isAnnotationPresent(ManyToMany.class) && !field.isAnnotationPresent(OneToOne.class) || (relationFromId = resultSet.getObject(EntityUtils.getColumnName(relationField))) == null) continue;
                                Object relationEntityManyToOne = null;
                                if (entityToIdMap.containsKey(relationFromId)) {
                                    if (field.isAnnotationPresent(ManyToMany.class)) {
                                        ((List)entityToIdMap.get(relationFromId)).add(relationEntityManyToOne);
                                    } else {
                                        relationEntityManyToOne = entityToIdMap.get(relationFromId);
                                    }
                                } else if (field.isAnnotationPresent(ManyToMany.class)) {
                                    entityToIdMap.put(relationFromId, new ArrayList());
                                    ((List)entityToIdMap.get(relationFromId)).add(relationEntityManyToOne);
                                } else {
                                    relationEntityManyToOne = this.valueClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                    entityToIdMap.put(relationFromId, relationEntityManyToOne);
                                }
                                DependencyInjector.setField(relationEntity, relationEntityManyToOne, relationField);
                                String relationKey = String.format("%s%s", relationFromId.toString(), field.getName());
                                if (field.isAnnotationPresent(OneToOne.class) && oneToMany.get(relationKey) == null) {
                                    oneToMany.put(relationKey, relationEntity);
                                    continue;
                                }
                                if (oneToMany.get(relationKey) == null) {
                                    oneToMany.put(relationKey, new ArrayList());
                                }
                                if ((!relationField.isAnnotationPresent(ManyToOne.class) || !relationField.getAnnotation(ManyToOne.class).value().equals(field.getName())) && (!relationField.isAnnotationPresent(ManyToMany.class) || !relationField.getAnnotation(ManyToMany.class).value().equals(field.getName())) || ((List)oneToMany.get(relationKey)).contains(relationEntity)) continue;
                                ((List)oneToMany.get(relationKey)).add(relationEntity);
                            }
                            Object list = oneToMany.get(String.format("%s%s", id.toString(), field.getName()));
                            DependencyInjector.setField(entity, list, field);
                        }
                        ++n2;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return resultFunction;
        }
    }

    private Object executeCountQuery(Method method, Object[] args) {
        String sql = QueryGenerator.generateQuery(method, this.tableName, this.valueClass, this.references);
        Object result = 0;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    statement.setObject(i + 1, args[i]);
                }
            }
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    result = resultSet.getObject(1);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<Object> executeCustomQuery(String sqlWithParams, Object[] args, Parameter[] parameters) {
        List<Object> result = new ArrayList<Object>();
        Object[] queryParameters = SQLQueryUtil.getParamsFromQuery(sqlWithParams);
        String sql = SQLQueryUtil.removeParamsFromQuery(sqlWithParams, (String[])queryParameters);
        sql = sql.replace("WHERE", QueryGenerator.getReferencesJoin(this.references, this.tableName) + " WHERE");
        this.logger.debug(Arrays.toString(queryParameters));
        this.logger.debug(sql);
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            if (args != null) {
                for (int i = 0; i < queryParameters.length; ++i) {
                    int optionalIndex = i;
                    Optional<Parameter> optional = Arrays.stream(parameters).filter(arg_0 -> RepositoryProxyHandler.lambda$executeCustomQuery$0((String[])queryParameters, optionalIndex, arg_0)).findFirst();
                    if (optional.isEmpty()) {
                        throw new RuntimeException((String)queryParameters[i] + " not found");
                    }
                    int position = Arrays.stream(parameters).toList().indexOf(optional.get());
                    statement.setObject(i + 1, args[position]);
                }
            }
            result = this.statementListExecutor(statement);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<Object> executeFindQuery(Method method, Object[] args) {
        String sql = QueryGenerator.generateQuery(method, this.tableName, this.valueClass, this.references);
        List<Object> result = new ArrayList<Object>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    statement.setObject(i + 1, args[i]);
                }
            }
            result = this.statementListExecutor(statement);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Object saveEntity(Object entity) {
        if (entity == null) {
            return entity;
        }
        if (List.class.isAssignableFrom(entity.getClass())) {
            for (Object subEntity : (List)entity) {
                this.saveEntity(subEntity);
            }
            return entity;
        }
        String entityTableName = EntityUtils.getTableName(entity.getClass());
        Object entityFields = EntityUtils.getColumnNameStream(entity.getClass()).collect(Collectors.joining(","));
        String sql = "INSERT INTO " + entityTableName + " (" + (String)entityFields + ") VALUES (" + EntityUtils.generateQuestionMarks((String)entityFields) + ")";
        try {
            Field idField = EntityUtils.getIdField(entity.getClass());
            idField.setAccessible(true);
            Object id = idField.get(entity);
            ArrayList<Object> saveList = new ArrayList<Object>();
            try {
                if (id != null) {
                    entityFields = EntityUtils.getColumnNameStream(entity.getClass()).collect(Collectors.joining(" = ?,")) + " = ?";
                    sql = "UPDATE " + entityTableName + " SET " + (String)entityFields + " WHERE " + EntityUtils.getColumnName(idField) + " = ?";
                }
            }
            catch (IllegalArgumentException | SecurityException e) {
                e.printStackTrace();
            }
            this.logger.debug(sql);
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                Field[] fields;
                int k = 1;
                for (Field field : fields = entity.getClass().getDeclaredFields()) {
                    Object fieldValue;
                    if (EntityUtils.isNotPK(field) && EntityUtils.isNotFK(field)) {
                        field.setAccessible(true);
                        fieldValue = field.get(entity);
                        if (!EntityUtils.isNotRelation(field)) {
                            Field fieldFK = EntityUtils.getIdField(field.getType());
                            fieldFK.setAccessible(true);
                            fieldValue = fieldFK.get(field.get(entity));
                        }
                        preparedStatement.setObject(k, fieldValue);
                        ++k;
                        continue;
                    }
                    if (EntityUtils.isNotFK(field)) continue;
                    field.setAccessible(true);
                    fieldValue = field.get(entity);
                    saveList.add(fieldValue);
                }
                if (id != null) {
                    preparedStatement.setObject(k, id);
                }
                preparedStatement.execute();
            }
            for (Object e : saveList) {
                this.saveEntity(e);
            }
        }
        catch (IllegalAccessException | SQLException e) {
            e.printStackTrace();
        }
        return entity;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Class<?> getKeyClass() {
        return this.keyClass;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public Class<?> getRepositoryInterface() {
        return this.repositoryInterface;
    }

    public List<Field> getReferences() {
        return this.references;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setKeyClass(Class<?> keyClass) {
        this.keyClass = keyClass;
    }

    public void setValueClass(Class<?> valueClass) {
        this.valueClass = valueClass;
    }

    public void setRepositoryInterface(Class<?> repositoryInterface) {
        this.repositoryInterface = repositoryInterface;
    }

    public void setReferences(List<Field> references) {
        this.references = references;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepositoryProxyHandler)) {
            return false;
        }
        RepositoryProxyHandler other = (RepositoryProxyHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        Class<?> this$keyClass = this.getKeyClass();
        Class<?> other$keyClass = other.getKeyClass();
        if (this$keyClass == null ? other$keyClass != null : !this$keyClass.equals(other$keyClass)) {
            return false;
        }
        Class<?> this$valueClass = this.getValueClass();
        Class<?> other$valueClass = other.getValueClass();
        if (this$valueClass == null ? other$valueClass != null : !this$valueClass.equals(other$valueClass)) {
            return false;
        }
        Class<?> this$repositoryInterface = this.getRepositoryInterface();
        Class<?> other$repositoryInterface = other.getRepositoryInterface();
        if (this$repositoryInterface == null ? other$repositoryInterface != null : !this$repositoryInterface.equals(other$repositoryInterface)) {
            return false;
        }
        List<Field> this$references = this.getReferences();
        List<Field> other$references = other.getReferences();
        if (this$references == null ? other$references != null : !((Object)this$references).equals(other$references)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RepositoryProxyHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        Class<?> $keyClass = this.getKeyClass();
        result = result * 59 + ($keyClass == null ? 43 : $keyClass.hashCode());
        Class<?> $valueClass = this.getValueClass();
        result = result * 59 + ($valueClass == null ? 43 : $valueClass.hashCode());
        Class<?> $repositoryInterface = this.getRepositoryInterface();
        result = result * 59 + ($repositoryInterface == null ? 43 : $repositoryInterface.hashCode());
        List<Field> $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : ((Object)$references).hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    public String toString() {
        return "RepositoryProxyHandler(dataSource=" + this.getDataSource() + ", tableName=" + this.getTableName() + ", keyClass=" + this.getKeyClass() + ", valueClass=" + this.getValueClass() + ", repositoryInterface=" + this.getRepositoryInterface() + ", references=" + this.getReferences() + ", logger=" + this.getLogger() + ")";
    }

    private static /* synthetic */ boolean lambda$executeCustomQuery$0(String[] queryParameters, int optionalIndex, Parameter parameter) {
        return parameter.getAnnotation(Param.class).value().equals(queryParameters[optionalIndex]);
    }
}

