/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.controller;

import com.dnlkk.controller.ControllerRegistry;
import com.dnlkk.controller.DispatcherServlet;
import com.dnlkk.controller.responses.ResponseEntity;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiDispatcherServlet
extends DispatcherServlet {
    private static final Logger logger = LoggerFactory.getLogger(ApiDispatcherServlet.class);

    public ApiDispatcherServlet(ControllerRegistry controllerRegistry) {
        super(controllerRegistry);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=UTF-8");
        if (this.dispatch(response, request)) {
            response.setStatus(404);
            response.getWriter().write("{\"error\": \"\u0420\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!\"}");
        }
    }

    @Override
    protected boolean controllerDispatch(Method controllerEndpoint, Object controllerReturn, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (controllerReturn.getClass().equals(ResponseEntity.class)) {
            ResponseEntity responseEntity = (ResponseEntity)controllerReturn;
            response.setStatus(responseEntity.getStatus().code());
            response.getWriter().write(responseEntity.json());
        } else if (controllerReturn.getClass().equals(String.class)) {
            response.getWriter().write(controllerReturn.toString());
        } else {
            return false;
        }
        return true;
    }
}

