/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.dependency_injector.application_context;

import com.dnlkk.boot.annotations.DnlkkApp;
import com.dnlkk.dependency_injector.DependencyInjector;
import com.dnlkk.dependency_injector.application_context.ComponentContainer;
import com.dnlkk.dependency_injector.application_context.ComponentFactory;
import com.dnlkk.dependency_injector.application_context.ConfigScanner;
import com.dnlkk.dependency_injector.application_context.PeaFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationContext
implements PeaFactory,
ComponentContainer {
    protected final String basePackage;
    protected final DependencyInjector dependencyInjector;
    protected final PeaFactory peaFactory;
    protected final ConfigScanner configScanner;
    protected final ComponentFactory componentFactory;
    private static final Logger logger = LoggerFactory.getLogger(ApplicationContext.class);

    public ApplicationContext(Object baseObject, PeaFactory peaFactory, ConfigScanner configScanner, ComponentFactory componentFactory) {
        String basePackage = baseObject.getClass().getPackageName();
        this.dependencyInjector = new DependencyInjector(this);
        this.basePackage = basePackage;
        this.configScanner = configScanner;
        this.peaFactory = peaFactory;
        this.componentFactory = componentFactory;
        this.componentFactory.setDependencyInjector(this.dependencyInjector);
        this.injectDependencies(baseObject);
        if (baseObject.getClass().isAnnotationPresent(DnlkkApp.class)) {
            Arrays.stream(baseObject.getClass().getMethods()).forEach(method -> {
                if (method.getName().equals("runApp")) {
                    try {
                        method.invoke(baseObject, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void injectDependencies(Object target) {
        this.peaFactory.setPeas(this.configScanner.scan(this.basePackage));
        this.componentFactory.initComponents(this.basePackage);
        this.dependencyInjector.inject(target);
        this.componentFactory.getComponents().values().stream().forEach(component -> this.dependencyInjector.inject(component));
    }

    @Override
    public <T> T getSingletonPea(Class<T> componentClass, String name) {
        return this.peaFactory.getSingletonPea(componentClass, name);
    }

    @Override
    public <T> T getSingletonPea(Class<T> componentClass) {
        return this.peaFactory.getSingletonPea(componentClass);
    }

    @Override
    public <T> T getPrototypePea(Class<T> componentClass, String name) {
        return this.peaFactory.getPrototypePea(componentClass, name);
    }

    @Override
    public <T> T getPrototypePea(Class<T> componentClass) {
        return this.peaFactory.getPrototypePea(componentClass);
    }

    @Override
    public <V> Map<String, V> getPeas() {
        return this.peaFactory.getPeas();
    }

    @Override
    public <V> void setPeas(Map<String, V> peas) {
        this.peaFactory.setPeas(peas);
    }

    @Override
    public boolean containsComponent(String componentClass) {
        return this.componentFactory.containsComponent(componentClass);
    }

    @Override
    public Object getComponent(String componentClass) {
        return this.componentFactory.getComponent(componentClass);
    }

    @Override
    public Map<String, Object> getComponents() {
        return this.componentFactory.getComponents();
    }
}

