/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.dependency_injector.annotation_context;

import com.dnlkk.dependency_injector.DependencyInjector;
import com.dnlkk.dependency_injector.annotations.components.Component;
import com.dnlkk.dependency_injector.annotations.components.Controller;
import com.dnlkk.dependency_injector.annotations.components.Repository;
import com.dnlkk.dependency_injector.annotations.components.RestController;
import com.dnlkk.dependency_injector.annotations.components.Service;
import com.dnlkk.dependency_injector.application_context.ComponentFactory;
import com.dnlkk.repository.DnlkkRepositoryFactory;
import com.dnlkk.util.ScannerUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class AnnotationComponentFactory
implements ComponentFactory {
    private Map<String, Object> components = new HashMap<String, Object>();
    private DependencyInjector dependencyInjector;

    @Override
    public void initComponents(String basePackage) {
        try {
            for (Class<?> clazz : ScannerUtils.findClassesFromDirectory(basePackage)) {
                if (!this.isComponentClass(clazz)) continue;
                Object componentInstance = null;
                componentInstance = !clazz.isAnnotationPresent(Repository.class) ? this.createComponentInstance(clazz) : DnlkkRepositoryFactory.createRepositoryInstance(clazz);
                this.components.put(clazz.getSimpleName(), componentInstance);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Failed to scan for components.");
        }
    }

    private boolean isComponentClass(Class<?> clazz) {
        return clazz.isAnnotationPresent(Component.class) || clazz.isAnnotationPresent(RestController.class) || clazz.isAnnotationPresent(Controller.class) || clazz.isAnnotationPresent(Service.class) || clazz.isAnnotationPresent(Repository.class);
    }

    private Object createComponentInstance(Class<?> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create an instance of " + clazz);
        }
    }

    @Override
    public boolean containsComponent(String componentClass) {
        return this.components.containsKey(componentClass);
    }

    @Override
    public Object getComponent(String componentClass) {
        return this.components.get(componentClass);
    }

    @Override
    public Map<String, Object> getComponents() {
        return this.components;
    }

    public DependencyInjector getDependencyInjector() {
        return this.dependencyInjector;
    }

    public void setComponents(Map<String, Object> components) {
        this.components = components;
    }

    @Override
    public void setDependencyInjector(DependencyInjector dependencyInjector) {
        this.dependencyInjector = dependencyInjector;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotationComponentFactory)) {
            return false;
        }
        AnnotationComponentFactory other = (AnnotationComponentFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$components = this.getComponents();
        Map<String, Object> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        DependencyInjector this$dependencyInjector = this.getDependencyInjector();
        DependencyInjector other$dependencyInjector = other.getDependencyInjector();
        return !(this$dependencyInjector == null ? other$dependencyInjector != null : !this$dependencyInjector.equals(other$dependencyInjector));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnnotationComponentFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        DependencyInjector $dependencyInjector = this.getDependencyInjector();
        result = result * 59 + ($dependencyInjector == null ? 43 : $dependencyInjector.hashCode());
        return result;
    }

    public String toString() {
        return "AnnotationComponentFactory(components=" + this.getComponents() + ", dependencyInjector=" + this.getDependencyInjector() + ")";
    }
}

