/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.doc;

import com.dnlkk.controller.annotations.RequestBody;
import com.dnlkk.controller.annotations.RequestMapping;
import com.dnlkk.controller.annotations.RequestParam;
import com.dnlkk.controller.annotations.request_method.Get;
import com.dnlkk.controller.annotations.request_method.Post;
import com.dnlkk.controller.responses.ResponseEntity;
import com.dnlkk.doc.RequestType;
import com.dnlkk.doc.annotation.ApiOperation;
import com.dnlkk.doc.annotation.Tag;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DocModelDnlkk {
    private String message;
    private ControllerModel[] controllers;

    public DocModelDnlkk(String message, Map<String, Object> controllers) {
        this.message = message;
        this.controllers = new ControllerModel[controllers.size()];
        int index = 0;
        for (Map.Entry<String, Object> o : controllers.entrySet()) {
            ControllerModel controller = DocModelDnlkk.getControllerModel(o);
            for (Method method : o.getValue().getClass().getDeclaredMethods()) {
                ControllerRequestModel controllerRequestModel = new ControllerRequestModel();
                for (Parameter p : method.getParameters()) {
                    if (p.isAnnotationPresent(RequestBody.class)) {
                        controllerRequestModel.setApiRequest(ControllerRequestModel.castClassToString(p.getType()));
                        continue;
                    }
                    if (!p.isAnnotationPresent(RequestParam.class)) continue;
                    controllerRequestModel.getRequestParameters().add(String.format("\"%s\": %s", p.getAnnotation(RequestParam.class).value(), p.getType().getSimpleName()));
                }
                if (method.isAnnotationPresent(Get.class)) {
                    controllerRequestModel.setRequestType(RequestType.GET);
                } else {
                    if (!method.isAnnotationPresent(Post.class)) continue;
                    controllerRequestModel.setRequestType(RequestType.POST);
                }
                if (method.isAnnotationPresent(RequestMapping.class)) {
                    controllerRequestModel.setMapping(method.getAnnotation(RequestMapping.class).value());
                }
                controllerRequestModel.setApiName(method.getName());
                controllerRequestModel.setApiResponse(ControllerRequestModel.castClassToString(method.getReturnType()));
                if (method.isAnnotationPresent(ApiOperation.class)) {
                    controllerRequestModel.setApiName(String.format("%s (%s)", method.getAnnotation(ApiOperation.class).name(), controllerRequestModel.getApiName()));
                    controllerRequestModel.setApiResponse(ControllerRequestModel.castClassToString(method.getAnnotation(ApiOperation.class).response()));
                }
                controller.requestModels.add(controllerRequestModel);
            }
            this.controllers[index] = controller;
            ++index;
        }
    }

    private static ControllerModel getControllerModel(Map.Entry<String, Object> o) {
        ControllerModel controller = new ControllerModel();
        controller.setMapping(o.getKey());
        Object controllerObject = o.getValue();
        controller.setTagName(controllerObject.getClass().getSimpleName());
        if (controllerObject.getClass().isAnnotationPresent(Tag.class)) {
            Tag tag = controllerObject.getClass().getAnnotation(Tag.class);
            controller.setTagName(String.format("%s (%s)", tag.name(), controller.getTagName()));
            controller.setTagDescription(tag.description());
        }
        return controller;
    }

    public String getMessage() {
        return this.message;
    }

    public ControllerModel[] getControllers() {
        return this.controllers;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setControllers(ControllerModel[] controllers) {
        this.controllers = controllers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocModelDnlkk)) {
            return false;
        }
        DocModelDnlkk other = (DocModelDnlkk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        return Arrays.deepEquals(this.getControllers(), other.getControllers());
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocModelDnlkk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getControllers());
        return result;
    }

    public String toString() {
        return "DocModelDnlkk(message=" + this.getMessage() + ", controllers=" + Arrays.deepToString(this.getControllers()) + ")";
    }

    public static class ControllerModel {
        private String mapping;
        private String tagName;
        private String tagDescription;
        private List<ControllerRequestModel> requestModels = new ArrayList<ControllerRequestModel>();

        public String getMapping() {
            return this.mapping;
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getTagDescription() {
            return this.tagDescription;
        }

        public List<ControllerRequestModel> getRequestModels() {
            return this.requestModels;
        }

        public void setMapping(String mapping) {
            this.mapping = mapping;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        public void setTagDescription(String tagDescription) {
            this.tagDescription = tagDescription;
        }

        public void setRequestModels(List<ControllerRequestModel> requestModels) {
            this.requestModels = requestModels;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControllerModel)) {
                return false;
            }
            ControllerModel other = (ControllerModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$mapping = this.getMapping();
            String other$mapping = other.getMapping();
            if (this$mapping == null ? other$mapping != null : !this$mapping.equals(other$mapping)) {
                return false;
            }
            String this$tagName = this.getTagName();
            String other$tagName = other.getTagName();
            if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
                return false;
            }
            String this$tagDescription = this.getTagDescription();
            String other$tagDescription = other.getTagDescription();
            if (this$tagDescription == null ? other$tagDescription != null : !this$tagDescription.equals(other$tagDescription)) {
                return false;
            }
            List<ControllerRequestModel> this$requestModels = this.getRequestModels();
            List<ControllerRequestModel> other$requestModels = other.getRequestModels();
            return !(this$requestModels == null ? other$requestModels != null : !((Object)this$requestModels).equals(other$requestModels));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ControllerModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mapping = this.getMapping();
            result = result * 59 + ($mapping == null ? 43 : $mapping.hashCode());
            String $tagName = this.getTagName();
            result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
            String $tagDescription = this.getTagDescription();
            result = result * 59 + ($tagDescription == null ? 43 : $tagDescription.hashCode());
            List<ControllerRequestModel> $requestModels = this.getRequestModels();
            result = result * 59 + ($requestModels == null ? 43 : ((Object)$requestModels).hashCode());
            return result;
        }

        public String toString() {
            return "DocModelDnlkk.ControllerModel(mapping=" + this.getMapping() + ", tagName=" + this.getTagName() + ", tagDescription=" + this.getTagDescription() + ", requestModels=" + this.getRequestModels() + ")";
        }
    }

    public static class ControllerRequestModel {
        private String mapping;
        private RequestType requestType;
        private String apiName;
        private String apiRequest;
        private List<String> requestParameters = new ArrayList<String>();
        private String apiResponse;

        private static String castClassToString(Class<?> clazz) {
            StringBuilder stringBuilder = new StringBuilder();
            if (clazz.equals(ResponseEntity.class)) {
                return "Got " + clazz.getSimpleName() + "<?>, please mark method with @ApiOperation(name, response)";
            }
            stringBuilder.append(String.format("%s: {\n", clazz.getSimpleName()));
            for (Field field : clazz.getDeclaredFields()) {
                stringBuilder.append("    ");
                stringBuilder.append(String.format("\"%s\": %s,\n", field.getName(), Collection.class.isAssignableFrom(field.getType()) ? field.getType().getSimpleName() + String.format("<%s>", ((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]).getSimpleName()) : (Map.class.isAssignableFrom(field.getType()) ? field.getType().getSimpleName() + String.format("<%s, %s>", ((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]).getSimpleName(), ((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1]).getSimpleName()) : field.getType().getSimpleName())));
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        public String getMapping() {
            return this.mapping;
        }

        public RequestType getRequestType() {
            return this.requestType;
        }

        public String getApiName() {
            return this.apiName;
        }

        public String getApiRequest() {
            return this.apiRequest;
        }

        public List<String> getRequestParameters() {
            return this.requestParameters;
        }

        public String getApiResponse() {
            return this.apiResponse;
        }

        public void setMapping(String mapping) {
            this.mapping = mapping;
        }

        public void setRequestType(RequestType requestType) {
            this.requestType = requestType;
        }

        public void setApiName(String apiName) {
            this.apiName = apiName;
        }

        public void setApiRequest(String apiRequest) {
            this.apiRequest = apiRequest;
        }

        public void setRequestParameters(List<String> requestParameters) {
            this.requestParameters = requestParameters;
        }

        public void setApiResponse(String apiResponse) {
            this.apiResponse = apiResponse;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControllerRequestModel)) {
                return false;
            }
            ControllerRequestModel other = (ControllerRequestModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$mapping = this.getMapping();
            String other$mapping = other.getMapping();
            if (this$mapping == null ? other$mapping != null : !this$mapping.equals(other$mapping)) {
                return false;
            }
            RequestType this$requestType = this.getRequestType();
            RequestType other$requestType = other.getRequestType();
            if (this$requestType == null ? other$requestType != null : !((Object)((Object)this$requestType)).equals((Object)other$requestType)) {
                return false;
            }
            String this$apiName = this.getApiName();
            String other$apiName = other.getApiName();
            if (this$apiName == null ? other$apiName != null : !this$apiName.equals(other$apiName)) {
                return false;
            }
            String this$apiRequest = this.getApiRequest();
            String other$apiRequest = other.getApiRequest();
            if (this$apiRequest == null ? other$apiRequest != null : !this$apiRequest.equals(other$apiRequest)) {
                return false;
            }
            List<String> this$requestParameters = this.getRequestParameters();
            List<String> other$requestParameters = other.getRequestParameters();
            if (this$requestParameters == null ? other$requestParameters != null : !((Object)this$requestParameters).equals(other$requestParameters)) {
                return false;
            }
            String this$apiResponse = this.getApiResponse();
            String other$apiResponse = other.getApiResponse();
            return !(this$apiResponse == null ? other$apiResponse != null : !this$apiResponse.equals(other$apiResponse));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ControllerRequestModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mapping = this.getMapping();
            result = result * 59 + ($mapping == null ? 43 : $mapping.hashCode());
            RequestType $requestType = this.getRequestType();
            result = result * 59 + ($requestType == null ? 43 : ((Object)((Object)$requestType)).hashCode());
            String $apiName = this.getApiName();
            result = result * 59 + ($apiName == null ? 43 : $apiName.hashCode());
            String $apiRequest = this.getApiRequest();
            result = result * 59 + ($apiRequest == null ? 43 : $apiRequest.hashCode());
            List<String> $requestParameters = this.getRequestParameters();
            result = result * 59 + ($requestParameters == null ? 43 : ((Object)$requestParameters).hashCode());
            String $apiResponse = this.getApiResponse();
            result = result * 59 + ($apiResponse == null ? 43 : $apiResponse.hashCode());
            return result;
        }

        public String toString() {
            return "DocModelDnlkk.ControllerRequestModel(mapping=" + this.getMapping() + ", requestType=" + this.getRequestType() + ", apiName=" + this.getApiName() + ", apiRequest=" + this.getApiRequest() + ", requestParameters=" + this.getRequestParameters() + ", apiResponse=" + this.getApiResponse() + ")";
        }
    }
}

