/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.repository.dnlkk_connection_pool;

import com.dnlkk.repository.dnlkk_connection_pool.DnlkkCPConfig;
import com.dnlkk.repository.dnlkk_connection_pool.DnlkkDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnlkkDataSourceFactory {
    private static final DnlkkCPConfig config = new DnlkkCPConfig();
    private static boolean isFirstConnect = true;
    private static final Logger logger = LoggerFactory.getLogger(DnlkkDataSourceFactory.class);

    public static DataSource createDataSource() {
        DnlkkDataSource dataSource = new DnlkkDataSource(config);
        try {
            Class.forName(config.getDriverClass());
        }
        catch (ClassNotFoundException e) {
            logger.error("DnlkkCP failed to load database driver");
            logger.error(e.getMessage());
            throw new RuntimeException("Failed to load database driver", e);
        }
        try (Connection connection = dataSource.getConnection();){
            if (isFirstConnect) {
                logger.info("DnlkkCP successfully connected with database");
                isFirstConnect = false;
            }
        }
        catch (SQLException e) {
            logger.error("DnlkkCP failed to connect with database");
            logger.error(e.getMessage());
            System.exit(-1);
        }
        return dataSource;
    }
}

