/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.repository;

import com.dnlkk.repository.DnlkkRepository;
import com.dnlkk.repository.RepositoryProxyHandler;
import com.dnlkk.repository.annotations.entity.Table;
import com.dnlkk.util.EntityUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnlkkRepositoryFactory {
    private static final Logger logger = LoggerFactory.getLogger(DnlkkRepositoryFactory.class);

    public static <K, V> DnlkkRepository<K, V> createRepositoryInstance(Class<?> clazz) {
        if (DnlkkRepository.class.isAssignableFrom(clazz)) {
            RepositoryProxyHandler handler = new RepositoryProxyHandler(clazz);
            String tableName = DnlkkRepositoryFactory.extractTableNameFromEntityClass(DnlkkRepositoryFactory.getValueClass(clazz));
            handler.setTableName(tableName);
            handler.setKeyClass(DnlkkRepositoryFactory.getKeyClass(clazz));
            handler.setValueClass(DnlkkRepositoryFactory.getValueClass(clazz));
            handler.setReferences(Arrays.stream(handler.getValueClass().getDeclaredFields()).filter(field -> !EntityUtils.isNotRelation(field)).toList());
            try {
                DnlkkRepository proxyObject = (DnlkkRepository)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, DnlkkRepository.class}, (InvocationHandler)handler);
                if (proxyObject == null) {
                    logger.error("Repository creation failed");
                    throw new Exception("Repository creation failed");
                }
                return proxyObject;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        logger.error("Not a repository");
        throw new IllegalArgumentException("Not a repository.");
    }

    private static <K, V> String extractTableNameFromEntityClass(Class<?> entityClass) {
        Table tableAnnotation = entityClass.getAnnotation(Table.class);
        if (tableAnnotation != null) {
            return tableAnnotation.value();
        }
        logger.error("No @Table annotation found on the entity class");
        throw new IllegalArgumentException("No @Table annotation found on the entity class.");
    }

    private static <K, V> Class<K> getKeyClass(Class<?> repositoryInterface) {
        ParameterizedType genericType = (ParameterizedType)repositoryInterface.getGenericInterfaces()[0];
        Type[] typeArguments = genericType.getActualTypeArguments();
        if (typeArguments.length >= 2) {
            Class keyClass = (Class)typeArguments[0];
            return keyClass;
        }
        logger.error("Unable to determine the key type");
        throw new IllegalArgumentException("Unable to determine the key type.");
    }

    public static <K, V> Class<V> getValueClass(Class<?> repositoryInterface) {
        ParameterizedType genericType = (ParameterizedType)repositoryInterface.getGenericInterfaces()[0];
        Type[] typeArguments = genericType.getActualTypeArguments();
        if (typeArguments.length >= 2) {
            Class valueClass = (Class)typeArguments[1];
            return valueClass;
        }
        logger.error("Unable to determine the value type");
        throw new IllegalArgumentException("Unable to determine the value type.");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DnlkkRepositoryFactory)) {
            return false;
        }
        DnlkkRepositoryFactory other = (DnlkkRepositoryFactory)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof DnlkkRepositoryFactory;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "DnlkkRepositoryFactory()";
    }
}

