/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.repository;

import com.dnlkk.repository.Pageable;
import com.dnlkk.repository.QueryOperation;
import com.dnlkk.repository.Sort;
import com.dnlkk.repository.annotations.entity.ManyToOne;
import com.dnlkk.repository.annotations.entity.OneToOne;
import com.dnlkk.repository.annotations.entity.Table;
import com.dnlkk.util.EntityUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryGenerator {
    private static final Logger logger = LoggerFactory.getLogger(QueryGenerator.class);

    /*
     * Enabled aggressive block sorting
     */
    public static String generateQuery(Method method, String tableName, Class<?> valueClass, List<Field> references, Object[] args) {
        Object methodPart;
        String part;
        String methodName = method.getName();
        Object[] methodParts = methodName.split("(?=[A-Z])");
        StringBuilder query = new StringBuilder();
        ArrayList<String> ignoredFields = null;
        if (args.length > 1) {
            ignoredFields = new ArrayList<String>(Arrays.stream((String[])args[args.length - 1]).toList());
        }
        Pageable pageable = Arrays.stream(args).filter(arg -> arg.getClass().equals(Pageable.class)).findFirst().map(Pageable.class::cast).orElse(null);
        logger.debug(Arrays.toString(methodParts));
        if (methodParts.length <= 0) {
            return null;
        }
        if (((String)methodParts[0]).equals(QueryOperation.FIND.getValue())) {
            query.append("SELECT ").append(tableName).append(".*");
            query.append(QueryGenerator.getReferencesAs(references, ignoredFields));
        } else if (((String)methodParts[0]).equals(QueryOperation.COUNT.getValue())) {
            query.append("SELECT COUNT( DISTINCT ").append(tableName).append(".").append(EntityUtils.getRelationIdFieldName(valueClass)).append(" ) ");
        } else if (((String)methodParts[0]).equals(QueryOperation.SUM.getValue())) {
            query.append("SELECT SUM( DISTINCT ").append(tableName).append(".").append(((String)methodParts[1]).toLowerCase()).append(") ");
        }
        if (pageable != null) {
            query.append(String.format(",ROW_NUMBER() OVER (PARTITION BY %1$s.%2$s ORDER BY %1$s.%2$s) AS rn ", tableName, EntityUtils.getRelationIdFieldName(valueClass)));
        }
        query.append("FROM ").append(tableName);
        boolean whereClauseAdded = false;
        boolean inClause = false;
        if (((String)methodParts[0]).equals(QueryOperation.FIND.getValue())) {
            query.append(QueryGenerator.getReferencesJoin(references, tableName, ignoredFields));
        }
        Field[] fields = valueClass.getDeclaredFields();
        Object[] objectArray = methodParts;
        int n = objectArray.length;
        block14: for (int i = 0; i < n && !(part = ((String)(methodPart = objectArray[i])).toLowerCase()).equals("ignored"); ++i) {
            Field fieldWhere;
            switch (part) {
                case "all": {
                    continue block14;
                }
                case "by": {
                    if (whereClauseAdded) break;
                    query.append(" WHERE");
                    whereClauseAdded = true;
                    break;
                }
                case "in": {
                    if (whereClauseAdded) break;
                    query.append(" WHERE");
                    whereClauseAdded = true;
                    inClause = true;
                    break;
                }
                case "or": {
                    query.append(" OR");
                    break;
                }
                case "and": {
                    query.append(" AND");
                }
            }
            if (!whereClauseAdded || (fieldWhere = (Field)Arrays.stream(fields).filter(field -> field.getName().toLowerCase().startsWith(part)).findFirst().orElse(null)) == null) continue;
            String paramName = EntityUtils.getColumnName(fieldWhere);
            query.append(" ").append(tableName).append(".").append(paramName);
            if (inClause) {
                query.append(" = ANY(?) ");
                continue;
            }
            query.append(" = ? ");
        }
        String resultQuery = query.toString();
        if (pageable != null) {
            StringBuilder stringBuilder = new StringBuilder(" ");
            if (pageable.getSort() != null) {
                stringBuilder.append(" ORDER BY  ");
                for (Sort sort : pageable.getSort()) {
                    stringBuilder.append(sort.getBy()).append(" ").append((Object)sort.getHow()).append(",");
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            resultQuery = String.format("WITH RankedMessages AS (%s %s), UniqueRankedMessages AS (    SELECT *     FROM RankedMessages    WHERE rn = 1     LIMIT %d     OFFSET %d ) SELECT * FROM RankedMessages WHERE %5$s IN (SELECT %5$s FROM UniqueRankedMessages) ", resultQuery, stringBuilder, pageable.getLimit(), pageable.getLimit() * pageable.getPage() + pageable.getOffset(), EntityUtils.getRelationIdFieldName(valueClass));
        }
        logger.debug(resultQuery);
        return resultQuery;
    }

    public static String getReferencesAs(List<Field> references, List<String> ignoredFields) {
        StringBuilder builder = new StringBuilder(" ");
        ArrayList<String> includedTableNames = new ArrayList<String>();
        if (!references.isEmpty()) {
            for (Field field : references) {
                Class targetClass;
                String targetTableName;
                if (ignoredFields.contains(field.getName()) || includedTableNames.contains(targetTableName = (targetClass = field.getType() == List.class ? (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] : (Class)field.getGenericType()).getAnnotation(Table.class).value())) continue;
                for (Field targetField : targetClass.getDeclaredFields()) {
                    String targetKey;
                    if (!EntityUtils.isNotFK(targetField) && (!targetField.isAnnotationPresent(OneToOne.class) || !targetField.getAnnotation(OneToOne.class).value().equals(field.getName())) && (!targetField.isAnnotationPresent(ManyToOne.class) || !targetField.getAnnotation(ManyToOne.class).value().equals(field.getName())) || (targetKey = EntityUtils.getColumnName(targetField)) == null) continue;
                    builder.append(",").append(targetTableName).append(".").append(targetKey).append(" AS ").append(targetTableName).append(targetKey).append(" ");
                }
                includedTableNames.add(targetTableName);
            }
        }
        return builder.toString();
    }

    public static String getReferencesJoin(List<Field> references, String tableName, List<String> ignoredFields) {
        StringBuilder builder = new StringBuilder(" ");
        HashSet<String> includedTableNames = new HashSet<String>();
        if (!references.isEmpty()) {
            for (Field field : references) {
                if (ignoredFields.contains(field.getName())) continue;
                String sourceKey = EntityUtils.getColumnName(EntityUtils.getIdField(references.get(0).getDeclaringClass()));
                Class targetClass = field.getType() == List.class ? (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] : (Class)field.getGenericType();
                String targetTableName = targetClass.getAnnotation(Table.class).value();
                String targetKey = null;
                if (field.isAnnotationPresent(OneToOne.class) || field.isAnnotationPresent(ManyToOne.class)) {
                    targetKey = EntityUtils.getColumnName(EntityUtils.getIdField(targetClass));
                    sourceKey = EntityUtils.getColumnName(field);
                } else {
                    for (Field targetField : targetClass.getDeclaredFields()) {
                        if ((!targetField.isAnnotationPresent(OneToOne.class) || !targetField.getAnnotation(OneToOne.class).value().equals(field.getName())) && (!targetField.isAnnotationPresent(ManyToOne.class) || !targetField.getAnnotation(ManyToOne.class).value().equals(field.getName()))) continue;
                        targetKey = EntityUtils.getColumnName(targetField);
                    }
                }
                if (targetKey == null) continue;
                if (includedTableNames.contains(targetTableName)) {
                    builder.append(" OR ").append(tableName).append(".").append(sourceKey).append(" = ").append(targetTableName).append(".").append(targetKey).append(" ");
                } else {
                    builder.append("LEFT JOIN ").append(targetTableName).append(" ON ").append(tableName).append(".").append(sourceKey).append(" = ").append(targetTableName).append(".").append(targetKey).append(" ");
                }
                includedTableNames.add(targetTableName);
            }
        }
        return builder.toString();
    }
}

