/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.repository;

import com.dnlkk.dependency_injector.DependencyInjector;
import com.dnlkk.repository.Pageable;
import com.dnlkk.repository.QueryGenerator;
import com.dnlkk.repository.QueryOperation;
import com.dnlkk.repository.annotations.Param;
import com.dnlkk.repository.annotations.Query;
import com.dnlkk.repository.annotations.entity.Date;
import com.dnlkk.repository.annotations.entity.ManyToMany;
import com.dnlkk.repository.annotations.entity.ManyToOne;
import com.dnlkk.repository.annotations.entity.OneToMany;
import com.dnlkk.repository.annotations.entity.OneToOne;
import com.dnlkk.repository.annotations.entity.PK;
import com.dnlkk.repository.dnlkk_connection_pool.DnlkkDataSourceFactory;
import com.dnlkk.util.EntityIgnoreUtils;
import com.dnlkk.util.EntityUtils;
import com.dnlkk.util.SQLQueryUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryProxyHandler
implements InvocationHandler {
    private final DataSource dataSource;
    private String tableName;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private Class<?> repositoryInterface;
    private List<Field> references;
    private final Logger logger = LoggerFactory.getLogger(RepositoryProxyHandler.class);
    private final Map<String, String> typesMap = new HashMap<String, String>();

    public RepositoryProxyHandler(Class<?> clazz) {
        this.repositoryInterface = clazz;
        this.dataSource = DnlkkDataSourceFactory.createDataSource();
        this.references = new ArrayList<Field>();
        this.typesMap.put("integer", "INTEGER");
        this.typesMap.put("string", "TEXT");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String[] ignoredFields = EntityIgnoreUtils.getIgnoredFieldFromMethod(method, this.valueClass);
        ArrayList<Object> arguments = new ArrayList<Object>(Arrays.stream(args).toList());
        arguments.add(ignoredFields);
        Object[] args2 = arguments.toArray(new Object[0]);
        Object result = null;
        if (method.isAnnotationPresent(Query.class)) {
            result = this.executeCustomQuery(method.getAnnotation(Query.class).value(), args2, method.getParameters());
        } else if (method.getName().startsWith(QueryOperation.FIND.getValue())) {
            result = this.executeFindQuery(method, args2);
        } else if (method.getName().startsWith(QueryOperation.COUNT.getValue()) || method.getName().startsWith(QueryOperation.SUM.getValue())) {
            result = this.executeCountQuery(method, args2);
        } else if (method.getName().startsWith(QueryOperation.SAVE.getValue())) {
            result = this.saveEntity(arguments.get(0));
        } else if (method.getName().startsWith(QueryOperation.DELETE.getValue())) {
            this.deleteEntity(arguments.get(0));
        }
        if (result != null && !List.class.isAssignableFrom(method.getReturnType()) && List.class.isAssignableFrom(result.getClass())) {
            result = ((List)result).size() > 0 ? ((List)result).get(0) : null;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Object> statementListExecutor(PreparedStatement statement, List<String> ignoredFields) throws SQLException {
        ArrayList<Object> resultFunction = new ArrayList<Object>();
        Object id = null;
        boolean idChange = false;
        HashMap<String, Object> relationObjects = new HashMap<String, Object>();
        HashMap<Object, Object> entityToIdMap = new HashMap<Object, Object>();
        Object entity = null;
        Field[] fields = null;
        try {
            entity = this.valueClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            fields = this.valueClass.getDeclaredFields();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        try (ResultSet resultSet = statement.executeQuery();){
            block11: while (resultSet.next()) {
                try {
                    Field[] fieldArray = fields;
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (true) {
                        block29: {
                            int n3;
                            Field[] fieldArray2;
                            Object relationFromId;
                            Object relationEntity;
                            Field field;
                            block31: {
                                block28: {
                                    block30: {
                                        if (n2 >= n) break block28;
                                        field = fieldArray[n2];
                                        if (ignoredFields.contains(field.getName())) break block29;
                                        if (!EntityUtils.isNotPK(field)) {
                                            Object newId = resultSet.getObject(EntityUtils.getColumnName(field));
                                            if (id == null || !id.equals(newId)) {
                                                id = newId;
                                                idChange = true;
                                                if (entityToIdMap.containsKey(id)) {
                                                    entity = entityToIdMap.get(id);
                                                } else {
                                                    entity = this.valueClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                                    entityToIdMap.put(id, entity);
                                                }
                                                for (Field field2 : fields) {
                                                    if (EntityUtils.isNotRelation(field2) || relationObjects.get(String.format("%s%s", id.toString(), field2.getName())) != null || field2.isAnnotationPresent(OneToOne.class) || field2.isAnnotationPresent(ManyToOne.class)) continue;
                                                    relationObjects.put(String.format("%s%s", id, field2.getName()), new ArrayList());
                                                }
                                            } else {
                                                idChange = false;
                                            }
                                        }
                                        if (!EntityUtils.isNotRelation(field)) break block30;
                                        Object retrievedObject = resultSet.getObject(EntityUtils.getColumnName(field));
                                        DependencyInjector.setField(entity, retrievedObject, field);
                                        break block29;
                                    }
                                    Class relationClazz = null;
                                    relationClazz = field.isAnnotationPresent(OneToOne.class) || field.isAnnotationPresent(ManyToOne.class) ? field.getType() : (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                                    relationEntity = relationClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                    relationFromId = null;
                                    if (field.isAnnotationPresent(ManyToOne.class) || field.isAnnotationPresent(OneToOne.class)) {
                                        DependencyInjector.setField(entity, relationEntity, field);
                                    }
                                    fieldArray2 = relationClazz.getDeclaredFields();
                                    n3 = fieldArray2.length;
                                    break block31;
                                }
                                if (!idChange) continue block11;
                                resultFunction.add(entity);
                            }
                            for (int i = 0; i < n3; ++i) {
                                Object relationEntityManyToOne;
                                Field relationField = fieldArray2[i];
                                if (EntityUtils.isNotRelation(relationField)) {
                                    Object retrievedObject = resultSet.getObject(EntityUtils.getTableName(relationField.getDeclaringClass()) + EntityUtils.getColumnName(relationField));
                                    DependencyInjector.setField(relationEntity, retrievedObject, relationField);
                                    continue;
                                }
                                try {
                                    relationFromId = resultSet.getObject(EntityUtils.getTableName(relationField.getDeclaringClass()) + EntityUtils.getColumnName(relationField));
                                }
                                catch (Exception ignored) {
                                    continue;
                                }
                                if (relationFromId == null) continue;
                                if (entityToIdMap.containsKey(relationFromId)) {
                                    relationEntityManyToOne = entityToIdMap.get(relationFromId);
                                } else {
                                    relationEntityManyToOne = this.valueClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                    for (Field relationEntityField : relationEntityManyToOne.getClass().getDeclaredFields()) {
                                        if (!relationEntityField.isAnnotationPresent(PK.class)) continue;
                                        relationEntityField.setAccessible(true);
                                        relationEntityField.set(relationEntityManyToOne, relationFromId);
                                    }
                                    entityToIdMap.put(relationFromId, relationEntityManyToOne);
                                }
                                DependencyInjector.setField(relationEntity, relationEntityManyToOne, relationField);
                                String relationKey = String.format("%s%s", relationFromId, field.getName());
                                if ((field.isAnnotationPresent(OneToOne.class) || field.isAnnotationPresent(ManyToOne.class)) && relationObjects.get(relationKey) == null) {
                                    relationObjects.put(relationKey, relationEntity);
                                    continue;
                                }
                                if (relationObjects.get(relationKey) == null) {
                                    relationObjects.computeIfAbsent(relationKey, k -> new ArrayList());
                                }
                                if ((!field.isAnnotationPresent(OneToMany.class) || !relationField.isAnnotationPresent(ManyToOne.class) || !relationField.getAnnotation(ManyToOne.class).value().equals(field.getName())) && !field.isAnnotationPresent(ManyToMany.class) || ((List)relationObjects.get(relationKey)).contains(relationEntity)) continue;
                                ((List)relationObjects.get(relationKey)).add(relationEntity);
                            }
                            Object list = relationObjects.get(String.format("%s%s", id, field.getName()));
                            DependencyInjector.setField(entity, list, field);
                        }
                        ++n2;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return resultFunction;
        }
    }

    private Object executeCountQuery(Method method, Object[] args) {
        String sql = QueryGenerator.generateQuery(method, this.tableName, this.valueClass, this.references, args);
        Object result = 0;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            for (int i = 0; i < args.length - 1; ++i) {
                statement.setObject(i + 1, args[i]);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    result = resultSet.getObject(1);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<Object> executeCustomQuery(String sqlWithParams, Object[] args, Parameter[] parameters) {
        List<Object> result = new ArrayList<Object>();
        Object[] queryParameters = SQLQueryUtil.getParamsFromQuery(sqlWithParams);
        ArrayList<String> ignoredFields = null;
        if (args.length > 1) {
            ignoredFields = new ArrayList<String>(Arrays.stream((String[])args[args.length - 1]).toList());
        }
        String sql = SQLQueryUtil.removeParamsFromQuery(sqlWithParams, (String[])queryParameters);
        sql = sql.replace("FROM", QueryGenerator.getReferencesAs(this.references, ignoredFields) + " FROM");
        sql = sql.replace("WHERE", QueryGenerator.getReferencesJoin(this.references, this.tableName, ignoredFields) + " WHERE");
        this.logger.debug(Arrays.toString(queryParameters));
        this.logger.debug(sql);
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            if (args != null) {
                for (int i = 0; i < queryParameters.length; ++i) {
                    int optionalIndex = i;
                    Optional<Parameter> optional = Arrays.stream(parameters).filter(arg_0 -> RepositoryProxyHandler.lambda$executeCustomQuery$1((String[])queryParameters, optionalIndex, arg_0)).findFirst();
                    if (optional.isEmpty()) {
                        throw new RuntimeException((String)queryParameters[i] + " not found");
                    }
                    int position = Arrays.stream(parameters).toList().indexOf(optional.get());
                    statement.setObject(i + 1, args[position]);
                }
            }
            result = this.statementListExecutor(statement, ignoredFields);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<Object> executeFindQuery(Method method, Object[] args) {
        String sql = QueryGenerator.generateQuery(method, this.tableName, this.valueClass, this.references, args);
        List<Object> result = new ArrayList<Object>();
        ArrayList<String> ignoredFields = new ArrayList();
        if (args.length > 1) {
            ignoredFields = new ArrayList<String>(Arrays.stream((String[])args[args.length - 1]).toList());
        }
        Pageable pageable = Arrays.stream(args).filter(arg -> arg.getClass().isAssignableFrom(Pageable.class)).findFirst().orElse(null);
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            for (int i = 0; i < args.length - 1; ++i) {
                if (args[i].getClass().equals(Pageable.class) || ignoredFields.contains(args[i])) continue;
                if (args[i].getClass().isArray()) {
                    statement.setArray(i + 1, connection.createArrayOf("integer", (Object[])args[i]));
                    continue;
                }
                statement.setObject(i + 1, args[i]);
            }
            result = this.statementListExecutor(statement, ignoredFields);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (pageable != null) {
            try {
                pageable.setTotalPages(((Long)this.executeCountQuery(this.repositoryInterface.getMethod("countAll", new Class[0]), new Object[0]) - (long)pageable.getOffset() - 1L) / (long)pageable.getLimit());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private Object saveEntity(Object entity) {
        block52: {
            if (entity == null) {
                return entity;
            }
            String entityTableName = EntityUtils.getTableName(this.valueClass);
            String entityFields = EntityUtils.getColumnNameStream(this.valueClass, false, true).collect(Collectors.joining(","));
            StringBuilder sql = new StringBuilder("INSERT INTO " + entityTableName + " (" + entityFields + ") VALUES ");
            String updateSql = null;
            ArrayList<Object> entities = new ArrayList<Object>();
            if (List.class.isAssignableFrom(entity.getClass())) {
                entities = new ArrayList((List)entity);
            } else {
                entities.add(entity);
            }
            try {
                Object idFK;
                Field idFKField;
                Field fieldFK;
                Object fieldValue;
                Connection connection;
                Field idField = EntityUtils.getIdField(this.valueClass);
                idField.setAccessible(true);
                ArrayList id = new ArrayList();
                for (Object e : entities) {
                    Iterator idValue = idField.get(e);
                    id.add(idValue);
                }
                for (Object e : id) {
                    if (e != null) continue;
                    sql.append("(").append(EntityUtils.generateQuestionMarks(entityFields)).append("),");
                }
                if (sql.charAt(sql.length() - 1) == ',') {
                    sql.deleteCharAt(sql.length() - 1);
                }
                sql.append(" RETURNING ").append(EntityUtils.getIdField(this.valueClass).getName());
                try {
                    if (!id.stream().filter(Objects::nonNull).toList().isEmpty()) {
                        entityFields = EntityUtils.getColumnNameStream(this.valueClass, false, true).map(c -> new StringBuffer((String)c).append(" = a2.").append((String)c)).collect(Collectors.joining(","));
                        String values = EntityUtils.getColumnNameStream(this.valueClass, true, true).collect(Collectors.joining(","));
                        StringBuilder stringBuilder = new StringBuilder();
                        for (Object e : id) {
                            stringBuilder.append("(").append(EntityUtils.generateQuestionMarks(values)).append("),");
                        }
                        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                        updateSql = String.format("UPDATE %s AS a SET %s FROM (VALUES %s ) AS a2(%s) WHERE a.%5$s = a2.%5$s;", this.tableName, entityFields, stringBuilder, values, EntityUtils.getColumnName(EntityUtils.getIdField(this.valueClass)));
                    }
                }
                catch (IllegalArgumentException | SecurityException e) {
                    e.printStackTrace();
                }
                if (id.contains(null)) {
                    this.logger.debug(sql.toString());
                }
                if (updateSql != null) {
                    this.logger.debug(updateSql.toString());
                }
                if (id.contains(null)) {
                    try {
                        connection = this.dataSource.getConnection();
                        try (PreparedStatement preparedStatement = connection.prepareStatement(sql.toString(), 1);){
                            int k = 1;
                            Field[] fieldArray = this.valueClass.getDeclaredFields();
                            for (int i = 0; i < entities.size(); ++i) {
                                if (id.get(i) != null) continue;
                                Field[] fieldArray2 = fieldArray;
                                int n = fieldArray2.length;
                                for (int j = 0; j < n; ++j) {
                                    Field field = fieldArray2[j];
                                    if (EntityUtils.isNotPK(field) && EntityUtils.isNotFK(field) && !field.isAnnotationPresent(Date.class)) {
                                        field.setAccessible(true);
                                        fieldValue = field.get(entities.get(i));
                                        if (!EntityUtils.isNotRelation(field)) {
                                            fieldFK = EntityUtils.getIdField(field.getType());
                                            fieldFK.setAccessible(true);
                                            fieldValue = fieldFK.get(field.get(entities.get(i)));
                                        }
                                        preparedStatement.setObject(k, fieldValue);
                                        ++k;
                                        continue;
                                    }
                                    if (EntityUtils.isNotFK(field) || field.isAnnotationPresent(OneToMany.class)) continue;
                                    field.setAccessible(true);
                                    fieldValue = field.get(entities.get(i));
                                    idFKField = EntityUtils.getIdField(fieldValue.getClass());
                                    idFKField.setAccessible(true);
                                    idFK = idFKField.get(fieldValue);
                                    preparedStatement.setObject(k, idFK);
                                    ++k;
                                }
                            }
                            preparedStatement.execute();
                            ResultSet generatedKeys = preparedStatement.getGeneratedKeys();
                            int i = 0;
                            while (generatedKeys.next()) {
                                Object generatedKey = generatedKeys.getObject(1);
                                while (id.get(i) != null) {
                                    ++i;
                                }
                                idField.set(entities.get(i), generatedKey);
                                ++i;
                            }
                        }
                        finally {
                            if (connection != null) {
                                connection.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                }
                if (updateSql == null) break block52;
                connection = this.dataSource.getConnection();
                try (PreparedStatement preparedStatement = connection.prepareStatement(updateSql.toString());){
                    int k = 1;
                    Field[] fieldArray = this.valueClass.getDeclaredFields();
                    for (int i = 0; i < entities.size(); ++i) {
                        if (id.get(i) == null) continue;
                        for (Field field : fieldArray) {
                            if (EntityUtils.isNotFK(field) && !field.isAnnotationPresent(Date.class)) {
                                field.setAccessible(true);
                                fieldValue = field.get(entities.get(i));
                                if (!EntityUtils.isNotRelation(field)) {
                                    fieldFK = EntityUtils.getIdField(field.getType());
                                    fieldFK.setAccessible(true);
                                    fieldValue = fieldFK.get(field.get(entities.get(i)));
                                }
                                preparedStatement.setObject(k, fieldValue);
                                ++k;
                                continue;
                            }
                            if (EntityUtils.isNotFK(field) || field.isAnnotationPresent(OneToMany.class)) continue;
                            field.setAccessible(true);
                            fieldValue = field.get(entities.get(i));
                            idFKField = EntityUtils.getIdField(fieldValue.getClass());
                            idFKField.setAccessible(true);
                            idFK = idFKField.get(fieldValue);
                            preparedStatement.setObject(k, idFK);
                            ++k;
                        }
                    }
                    preparedStatement.execute();
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (IllegalAccessException | SQLException e) {
                e.printStackTrace();
            }
        }
        return entity;
    }

    private void deleteEntity(Object id) {
        String sql = String.format("DELETE FROM %s WHERE %s = ?", this.tableName, EntityUtils.getRelationIdFieldName(this.valueClass));
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setObject(1, id);
            statement.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Class<?> getKeyClass() {
        return this.keyClass;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public Class<?> getRepositoryInterface() {
        return this.repositoryInterface;
    }

    public List<Field> getReferences() {
        return this.references;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Map<String, String> getTypesMap() {
        return this.typesMap;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setKeyClass(Class<?> keyClass) {
        this.keyClass = keyClass;
    }

    public void setValueClass(Class<?> valueClass) {
        this.valueClass = valueClass;
    }

    public void setRepositoryInterface(Class<?> repositoryInterface) {
        this.repositoryInterface = repositoryInterface;
    }

    public void setReferences(List<Field> references) {
        this.references = references;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepositoryProxyHandler)) {
            return false;
        }
        RepositoryProxyHandler other = (RepositoryProxyHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        Class<?> this$keyClass = this.getKeyClass();
        Class<?> other$keyClass = other.getKeyClass();
        if (this$keyClass == null ? other$keyClass != null : !this$keyClass.equals(other$keyClass)) {
            return false;
        }
        Class<?> this$valueClass = this.getValueClass();
        Class<?> other$valueClass = other.getValueClass();
        if (this$valueClass == null ? other$valueClass != null : !this$valueClass.equals(other$valueClass)) {
            return false;
        }
        Class<?> this$repositoryInterface = this.getRepositoryInterface();
        Class<?> other$repositoryInterface = other.getRepositoryInterface();
        if (this$repositoryInterface == null ? other$repositoryInterface != null : !this$repositoryInterface.equals(other$repositoryInterface)) {
            return false;
        }
        List<Field> this$references = this.getReferences();
        List<Field> other$references = other.getReferences();
        if (this$references == null ? other$references != null : !((Object)this$references).equals(other$references)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        Map<String, String> this$typesMap = this.getTypesMap();
        Map<String, String> other$typesMap = other.getTypesMap();
        return !(this$typesMap == null ? other$typesMap != null : !((Object)this$typesMap).equals(other$typesMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RepositoryProxyHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        Class<?> $keyClass = this.getKeyClass();
        result = result * 59 + ($keyClass == null ? 43 : $keyClass.hashCode());
        Class<?> $valueClass = this.getValueClass();
        result = result * 59 + ($valueClass == null ? 43 : $valueClass.hashCode());
        Class<?> $repositoryInterface = this.getRepositoryInterface();
        result = result * 59 + ($repositoryInterface == null ? 43 : $repositoryInterface.hashCode());
        List<Field> $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : ((Object)$references).hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        Map<String, String> $typesMap = this.getTypesMap();
        result = result * 59 + ($typesMap == null ? 43 : ((Object)$typesMap).hashCode());
        return result;
    }

    public String toString() {
        return "RepositoryProxyHandler(dataSource=" + this.getDataSource() + ", tableName=" + this.getTableName() + ", keyClass=" + this.getKeyClass() + ", valueClass=" + this.getValueClass() + ", repositoryInterface=" + this.getRepositoryInterface() + ", references=" + this.getReferences() + ", logger=" + this.getLogger() + ", typesMap=" + this.getTypesMap() + ")";
    }

    private static /* synthetic */ boolean lambda$executeCustomQuery$1(String[] queryParameters, int optionalIndex, Parameter parameter) {
        return parameter.getAnnotation(Param.class).value().equals(queryParameters[optionalIndex]);
    }
}

