/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.util;

import com.dnlkk.controller.annotations.PageableParam;
import com.dnlkk.controller.annotations.PathVar;
import com.dnlkk.controller.annotations.RequestBody;
import com.dnlkk.controller.annotations.RequestParam;
import com.dnlkk.controller.annotations.request_method.Patch;
import com.dnlkk.controller.annotations.request_method.Post;
import com.dnlkk.controller.annotations.request_method.Put;
import com.dnlkk.repository.helper.Pageable;
import com.dnlkk.repository.helper.Sort;
import com.dnlkk.util.EntityUtils;
import com.dnlkk.util.PathUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ControllerUtils {
    public static boolean methodEquals(Method controllerEndpoint, Class<? extends Annotation> methodClass, String requestType) {
        boolean requestEquals = requestType.equals(methodClass.getSimpleName().toUpperCase());
        return controllerEndpoint.isAnnotationPresent(methodClass) && !requestEquals || !controllerEndpoint.isAnnotationPresent(methodClass) && requestEquals;
    }

    public static List<Object> getParametersFromRequest(Method controllerEndpoint, String methodPath, String requestMapping, Map<String, String[]> parametersMap, String body) throws JsonProcessingException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        List<String> requestPaths = Arrays.stream(PathUtils.splitPath("/", methodPath)).toList();
        List<String> requestMappingPaths = Arrays.stream(PathUtils.splitPath("/", requestMapping)).toList();
        for (Parameter parameter : controllerEndpoint.getParameters()) {
            int index;
            if (parameter.isAnnotationPresent(PageableParam.class)) {
                Integer limit = null;
                if (parametersMap.containsKey("limit")) {
                    limit = Integer.parseInt(parametersMap.get("limit")[0]);
                }
                Integer page = null;
                if (parametersMap.containsKey("page")) {
                    page = Integer.parseInt(parametersMap.get("page")[0]);
                }
                Integer offset = null;
                if (parametersMap.containsKey("offset")) {
                    offset = Integer.parseInt(parametersMap.get("offset")[0]);
                }
                String[] sort = null;
                if (parametersMap.containsKey("sort")) {
                    sort = parametersMap.get("sort");
                }
                Pageable.PageableBuilder pageableBuilder = Pageable.builder().limit(limit != null ? limit : 10).page(page != null ? page : 0).offset(offset != null ? offset : 0);
                if (sort != null) {
                    ArrayList<Sort> sortList = new ArrayList<Sort>();
                    for (String sortString : sort) {
                        sortList.add(new Sort(sortString.split(" ")));
                    }
                    pageableBuilder.sort(sortList.toArray(new Sort[0]));
                }
                parameters.add(pageableBuilder.build());
                continue;
            }
            if (parameter.isAnnotationPresent(RequestParam.class)) {
                if (parametersMap.containsKey(parameter.getAnnotation(RequestParam.class).value())) {
                    String[] params = parametersMap.get(parameter.getAnnotation(RequestParam.class).value())[0].split(",");
                    if (!parameter.getType().isArray() && params.length == 1) {
                        parameters.add(ControllerUtils.parameterCast(parameter, params[0]));
                        continue;
                    }
                    Object[] returnObject = Arrays.copyOf(params, params.length);
                    if (parameter.getType().getComponentType().equals(Integer.class)) {
                        returnObject = new Integer[params.length];
                        for (int i = 0; i < returnObject.length; ++i) {
                            returnObject[i] = Integer.parseInt(params[i]);
                        }
                    }
                    parameters.add(returnObject);
                    continue;
                }
                parameters.add(null);
                continue;
            }
            if ((controllerEndpoint.isAnnotationPresent(Post.class) || controllerEndpoint.isAnnotationPresent(Patch.class) || controllerEndpoint.isAnnotationPresent(Put.class)) && parameter.isAnnotationPresent(RequestBody.class)) {
                parameters.add(EntityUtils.objectMapper.readValue(body, parameter.getType()));
                continue;
            }
            if (!parameter.isAnnotationPresent(PathVar.class) || (index = requestMappingPaths.indexOf(String.format(":%s", parameter.getAnnotation(PathVar.class).value()))) == -1) continue;
            if (parameter.getType().equals(Integer.class)) {
                parameters.add(Integer.parseInt(requestPaths.get(index)));
                continue;
            }
            parameters.add(requestPaths.get(index));
        }
        return parameters;
    }

    public static Object parameterCast(Parameter parameter, Object param) {
        if (parameter.getType().equals(Integer.class)) {
            return Integer.parseInt((String)param);
        }
        return parameter.getType().cast(param);
    }
}

