/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.boot;

import com.dnlkk.boot.AppConfig;
import java.util.Objects;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Banner {
    private static String banner;
    private static final Logger logger;

    public static String init(Class<?> clazz) {
        Scanner scanner = new Scanner(Objects.requireNonNull((clazz == null ? Banner.class : clazz).getClassLoader().getResourceAsStream(AppConfig.configIsLoaded() ? "banner.txt" : "base_banner.txt")));
        try {
            StringBuilder stringBuilder = new StringBuilder();
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                stringBuilder.append(line).append("\n");
            }
            banner = stringBuilder.toString();
            String string = banner = Banner.inputArgs();
            scanner.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error("banner.txt in resources not found");
                return null;
            }
        }
    }

    private static String inputArgs() {
        String version = AppConfig.getBaseProperty("app.version");
        String versionName = AppConfig.getBaseProperty("app.version_name");
        banner = banner.replace("%ver", version);
        banner = banner.replace("%vname", versionName);
        if (AppConfig.configIsLoaded()) {
            String projectVersion = AppConfig.getProperty("app.version");
            String projectName = AppConfig.getProperty("app.name");
            banner = projectVersion == null && projectName == null ? banner.replace(":: %pname v%pver ::", "") : (projectVersion != null && projectName != null ? banner.replace("%pname v%pver", projectName + " " + projectVersion) : banner.replace("%pname v%pver", Objects.requireNonNullElse(projectVersion, projectName)));
        }
        return banner;
    }

    public String toString() {
        return banner;
    }

    static {
        logger = LoggerFactory.getLogger(Banner.class);
    }
}

