/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.controller;

import com.dnlkk.boot.AppConfig;
import com.dnlkk.controller.ControllerRegistry;
import com.dnlkk.controller.annotations.RequestMapping;
import com.dnlkk.controller.annotations.request_method.Delete;
import com.dnlkk.controller.annotations.request_method.Get;
import com.dnlkk.controller.annotations.request_method.Patch;
import com.dnlkk.controller.annotations.request_method.Post;
import com.dnlkk.controller.annotations.request_method.Put;
import com.dnlkk.util.ControllerUtils;
import com.dnlkk.util.PathUtils;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DispatcherServlet
extends HttpServlet {
    protected final ControllerRegistry controllerRegistry;
    protected final String contextPath = AppConfig.getProperty("app.context-path");
    private static final Logger logger = LoggerFactory.getLogger(DispatcherServlet.class);

    public boolean dispatch(HttpServletResponse response, HttpServletRequest request) {
        Map parametersMap = request.getParameterMap();
        Map.Entry<String, Object> entryMapController = this.getEntryMapControllerFromRequest(request);
        if (entryMapController == null) {
            throw new RuntimeException("Controller doesn't exists!");
        }
        Object controller = entryMapController.getValue();
        String methodPath = this.getMethodPath(entryMapController.getKey(), request);
        if (controller != null) {
            return Arrays.stream(controller.getClass().getDeclaredMethods()).filter(controllerEndpoint -> {
                String requestMapping = this.getRequestMapping((Method)controllerEndpoint);
                if (requestMapping == null) {
                    return false;
                }
                if (PathUtils.isRequestMapping(methodPath, requestMapping)) {
                    if (ControllerUtils.methodEquals(controllerEndpoint, Get.class, request.getMethod())) {
                        return false;
                    }
                    if (ControllerUtils.methodEquals(controllerEndpoint, Post.class, request.getMethod())) {
                        return false;
                    }
                    if (ControllerUtils.methodEquals(controllerEndpoint, Delete.class, request.getMethod())) {
                        return false;
                    }
                    if (ControllerUtils.methodEquals(controllerEndpoint, Patch.class, request.getMethod())) {
                        return false;
                    }
                    if (ControllerUtils.methodEquals(controllerEndpoint, Put.class, request.getMethod())) {
                        return false;
                    }
                    try {
                        String body = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
                        List<Object> parameters = ControllerUtils.getParametersFromRequest(controllerEndpoint, methodPath, requestMapping, parametersMap, body);
                        Object controllerReturn = controllerEndpoint.invoke(controller, parameters.toArray());
                        return this.controllerDispatch((Method)controllerEndpoint, controllerReturn, request, response);
                    }
                    catch (IOException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        logger.error(e.getMessage());
                    }
                }
                return false;
            }).toList().isEmpty();
        }
        return true;
    }

    protected abstract boolean controllerDispatch(Method var1, Object var2, HttpServletRequest var3, HttpServletResponse var4) throws IOException;

    protected String getRequestMapping(Method controllerEndpoint) {
        if (controllerEndpoint.isAnnotationPresent(RequestMapping.class)) {
            return controllerEndpoint.getAnnotation(RequestMapping.class).value();
        }
        return null;
    }

    protected String getMethodPath(String controllerPath, HttpServletRequest request) {
        String path = request.getRequestURI();
        if (path.startsWith(this.contextPath + "/api")) {
            path = path.substring(this.contextPath.length() + 4);
        }
        String substring = controllerPath.endsWith(".html") ? path.substring(0, path.length() - controllerPath.length()) : path.substring(controllerPath.length());
        return controllerPath.length() == path.length() ? "/" : substring;
    }

    protected Map.Entry<String, Object> getEntryMapControllerFromRequest(HttpServletRequest request) {
        String path = request.getRequestURI();
        if (path.startsWith(this.contextPath + "/api")) {
            path = path.substring(this.contextPath.length() + 4);
        }
        String finalPath = path;
        Optional<Map.Entry> optionalEntryMapController = this.controllerRegistry.getControllers().entrySet().stream().filter(entryMapController -> {
            if (finalPath.endsWith(".html")) {
                return finalPath.endsWith((String)entryMapController.getKey());
            }
            return finalPath.startsWith((String)entryMapController.getKey());
        }).findFirst();
        if (optionalEntryMapController.isEmpty()) {
            return null;
        }
        return optionalEntryMapController.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DispatcherServlet)) {
            return false;
        }
        DispatcherServlet other = (DispatcherServlet)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ControllerRegistry this$controllerRegistry = this.getControllerRegistry();
        ControllerRegistry other$controllerRegistry = other.getControllerRegistry();
        if (this$controllerRegistry == null ? other$controllerRegistry != null : !((Object)this$controllerRegistry).equals(other$controllerRegistry)) {
            return false;
        }
        String this$contextPath = this.getContextPath();
        String other$contextPath = other.getContextPath();
        return !(this$contextPath == null ? other$contextPath != null : !this$contextPath.equals(other$contextPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DispatcherServlet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ControllerRegistry $controllerRegistry = this.getControllerRegistry();
        result = result * 59 + ($controllerRegistry == null ? 43 : ((Object)$controllerRegistry).hashCode());
        String $contextPath = this.getContextPath();
        result = result * 59 + ($contextPath == null ? 43 : $contextPath.hashCode());
        return result;
    }

    public ControllerRegistry getControllerRegistry() {
        return this.controllerRegistry;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String toString() {
        return "DispatcherServlet(controllerRegistry=" + this.getControllerRegistry() + ", contextPath=" + this.getContextPath() + ")";
    }

    public DispatcherServlet(ControllerRegistry controllerRegistry) {
        this.controllerRegistry = controllerRegistry;
    }
}

