/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.controller;

import com.dnlkk.boot.AppConfig;
import com.dnlkk.controller.ApiDispatcherServlet;
import com.dnlkk.controller.JspDispatcherServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import java.io.File;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.jasper.servlet.JasperInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontController {
    private final Logger logger = LoggerFactory.getLogger(FrontController.class);
    private final ApiDispatcherServlet apiDispatcherServlet;
    private final JspDispatcherServlet jspDispatcherServlet;
    private Tomcat tomcat;

    public FrontController(ApiDispatcherServlet apiDispatcherServlet, JspDispatcherServlet jspDispatcherServlet) {
        File webapp;
        this.apiDispatcherServlet = apiDispatcherServlet;
        this.jspDispatcherServlet = jspDispatcherServlet;
        Tomcat tomcat = new Tomcat();
        String portProperty = AppConfig.getProperty("app.port");
        int port = portProperty == null ? 8080 : Integer.parseInt(portProperty);
        String hostname = AppConfig.getProperty("app.hostname");
        tomcat.setPort(port);
        tomcat.setHostname(hostname != null ? hostname : "localhost");
        try {
            webapp = new File("src/main/webapp");
        }
        catch (NullPointerException e) {
            webapp = new File("src/main");
        }
        StandardContext ctx = (StandardContext)tomcat.addWebapp("", webapp.getAbsolutePath());
        File additionWebInfClasses = new File("target/classes");
        StandardRoot resources = new StandardRoot((Context)ctx);
        resources.addPreResources((WebResourceSet)new DirResourceSet((WebResourceRoot)resources, "/META-INF/resources", additionWebInfClasses.getAbsolutePath(), "/"));
        ctx.setResources((WebResourceRoot)resources);
        String contextPath = AppConfig.getProperty("app.context-path");
        if (contextPath == null) {
            contextPath = "";
        }
        Tomcat.addServlet((Context)ctx, (String)"DispatcherServlet", (Servlet)this.apiDispatcherServlet);
        ctx.addServletMappingDecoded(contextPath + "/api/*", "DispatcherServlet");
        Tomcat.addServlet((Context)ctx, (String)"JspDispatcherServlet", (Servlet)this.jspDispatcherServlet);
        ctx.addServletMappingDecoded("*.html", "JspDispatcherServlet");
        this.tomcat = tomcat;
        this.tomcat.getConnector();
        try {
            this.tomcat.start();
        }
        catch (LifecycleException e) {
            e.printStackTrace();
        }
        JasperInitializer initializer = new JasperInitializer();
        try {
            initializer.onStartup(null, ctx.getServletContext());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.tomcat.getServer().await();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ApiDispatcherServlet getApiDispatcherServlet() {
        return this.apiDispatcherServlet;
    }

    public JspDispatcherServlet getJspDispatcherServlet() {
        return this.jspDispatcherServlet;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public void setTomcat(Tomcat tomcat) {
        this.tomcat = tomcat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FrontController)) {
            return false;
        }
        FrontController other = (FrontController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        ApiDispatcherServlet this$apiDispatcherServlet = this.getApiDispatcherServlet();
        ApiDispatcherServlet other$apiDispatcherServlet = other.getApiDispatcherServlet();
        if (this$apiDispatcherServlet == null ? other$apiDispatcherServlet != null : !((Object)((Object)this$apiDispatcherServlet)).equals((Object)other$apiDispatcherServlet)) {
            return false;
        }
        JspDispatcherServlet this$jspDispatcherServlet = this.getJspDispatcherServlet();
        JspDispatcherServlet other$jspDispatcherServlet = other.getJspDispatcherServlet();
        if (this$jspDispatcherServlet == null ? other$jspDispatcherServlet != null : !((Object)((Object)this$jspDispatcherServlet)).equals((Object)other$jspDispatcherServlet)) {
            return false;
        }
        Tomcat this$tomcat = this.getTomcat();
        Tomcat other$tomcat = other.getTomcat();
        return !(this$tomcat == null ? other$tomcat != null : !this$tomcat.equals(other$tomcat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FrontController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        ApiDispatcherServlet $apiDispatcherServlet = this.getApiDispatcherServlet();
        result = result * 59 + ($apiDispatcherServlet == null ? 43 : ((Object)((Object)$apiDispatcherServlet)).hashCode());
        JspDispatcherServlet $jspDispatcherServlet = this.getJspDispatcherServlet();
        result = result * 59 + ($jspDispatcherServlet == null ? 43 : ((Object)((Object)$jspDispatcherServlet)).hashCode());
        Tomcat $tomcat = this.getTomcat();
        result = result * 59 + ($tomcat == null ? 43 : $tomcat.hashCode());
        return result;
    }

    public String toString() {
        return "FrontController(logger=" + this.getLogger() + ", apiDispatcherServlet=" + this.getApiDispatcherServlet() + ", jspDispatcherServlet=" + this.getJspDispatcherServlet() + ", tomcat=" + this.getTomcat() + ")";
    }
}

