/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.dependency_injector.annotation_context;

import com.dnlkk.dependency_injector.annotations.Pea;
import com.dnlkk.dependency_injector.application_context.ConfigScanner;
import com.dnlkk.dependency_injector.config.Config;
import com.dnlkk.dependency_injector.config.PeaObject;
import com.dnlkk.util.ScannerUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AnnotationConfigScanner
implements ConfigScanner {
    private Set<Class<?>> configClasses = new HashSet();

    @Override
    public Set<Class<?>> findConfigClasses(String basePackage) {
        try {
            for (Class<?> clazz : ScannerUtils.findClassesFromDirectory(basePackage)) {
                if (!clazz.isAnnotationPresent(Config.class)) continue;
                this.configClasses.add(clazz);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Failed to scan for @Config classes.");
        }
        return this.configClasses;
    }

    private Object createInstance(Class<?> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create an instance of " + clazz);
        }
    }

    private Object invokePeaMethod(Object configInstance, Method method) {
        try {
            return method.invoke(configInstance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to invoke @Pea method " + method.getName());
        }
    }

    public Map<String, PeaObject> scan(String basePackage) {
        this.configClasses = this.findConfigClasses(basePackage);
        HashMap<String, PeaObject> peas = new HashMap<String, PeaObject>();
        for (Class<?> configClass : this.configClasses) {
            Object configInstance = this.createInstance(configClass);
            for (Method method : configClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Pea.class)) continue;
                Object peaInstance = this.invokePeaMethod(configInstance, method);
                if (peas.containsKey(method.getName())) {
                    try {
                        throw new Exception(String.format("@Pea with the title: '%s' should be presented in only one @Config", method.getName()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                        continue;
                    }
                }
                peas.put(method.getName(), new PeaObject(peaInstance, method, configInstance));
            }
        }
        return peas;
    }

    @Override
    public Set<Class<?>> getConfigClasses() {
        return this.configClasses;
    }

    public void setConfigClasses(Set<Class<?>> configClasses) {
        this.configClasses = configClasses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotationConfigScanner)) {
            return false;
        }
        AnnotationConfigScanner other = (AnnotationConfigScanner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<Class<?>> this$configClasses = this.getConfigClasses();
        Set<Class<?>> other$configClasses = other.getConfigClasses();
        return !(this$configClasses == null ? other$configClasses != null : !((Object)this$configClasses).equals(other$configClasses));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnnotationConfigScanner;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Class<?>> $configClasses = this.getConfigClasses();
        result = result * 59 + ($configClasses == null ? 43 : ((Object)$configClasses).hashCode());
        return result;
    }

    public String toString() {
        return "AnnotationConfigScanner(configClasses=" + this.getConfigClasses() + ")";
    }
}

