/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.repository.helper;

public class Sort {
    private String by;
    private SortHow how;

    public Sort() {
        this("id");
    }

    public Sort(String by) {
        this.by = by;
        this.how = SortHow.ASC;
    }

    public Sort(String[] queryParam) {
        if (queryParam.length == 1) {
            this.by = queryParam[0];
            this.how = SortHow.ASC;
        } else if (queryParam.length == 2) {
            this.by = queryParam[0];
            this.how = SortHow.valueOf(queryParam[1].toUpperCase());
        } else {
            throw new RuntimeException("Only 2 params for sort");
        }
    }

    public Sort(String by, SortHow how) {
        this.by = by;
        this.how = how;
    }

    public Sort(String by, String how) {
        this.by = by;
        this.how = SortHow.valueOf(how.toUpperCase());
    }

    public static Sort randomSort() {
        return new Sort("random()");
    }

    public static SortBuilder builder() {
        return new SortBuilder();
    }

    public String getBy() {
        return this.by;
    }

    public SortHow getHow() {
        return this.how;
    }

    public void setBy(String by) {
        this.by = by;
    }

    public void setHow(SortHow how) {
        this.how = how;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Sort other = (Sort)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$by = this.getBy();
        String other$by = other.getBy();
        if (this$by == null ? other$by != null : !this$by.equals(other$by)) {
            return false;
        }
        SortHow this$how = this.getHow();
        SortHow other$how = other.getHow();
        return !(this$how == null ? other$how != null : !((Object)((Object)this$how)).equals((Object)other$how));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sort;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $by = this.getBy();
        result = result * 59 + ($by == null ? 43 : $by.hashCode());
        SortHow $how = this.getHow();
        result = result * 59 + ($how == null ? 43 : ((Object)((Object)$how)).hashCode());
        return result;
    }

    public String toString() {
        return "Sort(by=" + this.getBy() + ", how=" + this.getHow() + ")";
    }

    public static enum SortHow {
        DESC("desc"),
        ASC("asc");

        private final String title;

        private SortHow(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class SortBuilder {
        private String by;
        private SortHow how;

        SortBuilder() {
        }

        public SortBuilder by(String by) {
            this.by = by;
            return this;
        }

        public SortBuilder how(SortHow how) {
            this.how = how;
            return this;
        }

        public Sort build() {
            return new Sort(this.by, this.how);
        }

        public String toString() {
            return "Sort.SortBuilder(by=" + this.by + ", how=" + this.how + ")";
        }
    }
}

