/*
 * Decompiled with CFR 0.152.
 */
package com.dnlkk.security;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class CORSPolicy {
    private final String accessControlAllowOrigin;
    private final String accessControlAllowMethods;
    private final String accessControlAllowHeaders;
    private final String accessControlAllowCredentials;

    public final HttpServletResponse response(HttpServletResponse httpServletResponse) {
        if (this.accessControlAllowOrigin != null) {
            httpServletResponse.setHeader("Access-Control-Allow-Origin", this.accessControlAllowOrigin);
        }
        if (this.accessControlAllowMethods != null) {
            httpServletResponse.setHeader("Access-Control-Allow-Methods", this.accessControlAllowMethods);
        }
        if (this.accessControlAllowHeaders != null) {
            httpServletResponse.setHeader("Access-Control-Allow-Headers", this.accessControlAllowHeaders);
        }
        if (this.accessControlAllowCredentials != null) {
            httpServletResponse.setHeader("Access-Control-Allow-Credentials", this.accessControlAllowCredentials);
        }
        return httpServletResponse;
    }

    public final HttpServletRequest request(HttpServletRequest httpServletRequest) {
        return httpServletRequest;
    }

    public CORSPolicy(String accessControlAllowOrigin, String accessControlAllowMethods, String accessControlAllowHeaders, String accessControlAllowCredentials) {
        this.accessControlAllowOrigin = accessControlAllowOrigin;
        this.accessControlAllowMethods = accessControlAllowMethods;
        this.accessControlAllowHeaders = accessControlAllowHeaders;
        this.accessControlAllowCredentials = accessControlAllowCredentials;
    }

    public String getAccessControlAllowOrigin() {
        return this.accessControlAllowOrigin;
    }

    public String getAccessControlAllowMethods() {
        return this.accessControlAllowMethods;
    }

    public String getAccessControlAllowHeaders() {
        return this.accessControlAllowHeaders;
    }

    public String getAccessControlAllowCredentials() {
        return this.accessControlAllowCredentials;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CORSPolicy)) {
            return false;
        }
        CORSPolicy other = (CORSPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accessControlAllowOrigin = this.getAccessControlAllowOrigin();
        String other$accessControlAllowOrigin = other.getAccessControlAllowOrigin();
        if (this$accessControlAllowOrigin == null ? other$accessControlAllowOrigin != null : !this$accessControlAllowOrigin.equals(other$accessControlAllowOrigin)) {
            return false;
        }
        String this$accessControlAllowMethods = this.getAccessControlAllowMethods();
        String other$accessControlAllowMethods = other.getAccessControlAllowMethods();
        if (this$accessControlAllowMethods == null ? other$accessControlAllowMethods != null : !this$accessControlAllowMethods.equals(other$accessControlAllowMethods)) {
            return false;
        }
        String this$accessControlAllowHeaders = this.getAccessControlAllowHeaders();
        String other$accessControlAllowHeaders = other.getAccessControlAllowHeaders();
        if (this$accessControlAllowHeaders == null ? other$accessControlAllowHeaders != null : !this$accessControlAllowHeaders.equals(other$accessControlAllowHeaders)) {
            return false;
        }
        String this$accessControlAllowCredentials = this.getAccessControlAllowCredentials();
        String other$accessControlAllowCredentials = other.getAccessControlAllowCredentials();
        return !(this$accessControlAllowCredentials == null ? other$accessControlAllowCredentials != null : !this$accessControlAllowCredentials.equals(other$accessControlAllowCredentials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CORSPolicy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessControlAllowOrigin = this.getAccessControlAllowOrigin();
        result = result * 59 + ($accessControlAllowOrigin == null ? 43 : $accessControlAllowOrigin.hashCode());
        String $accessControlAllowMethods = this.getAccessControlAllowMethods();
        result = result * 59 + ($accessControlAllowMethods == null ? 43 : $accessControlAllowMethods.hashCode());
        String $accessControlAllowHeaders = this.getAccessControlAllowHeaders();
        result = result * 59 + ($accessControlAllowHeaders == null ? 43 : $accessControlAllowHeaders.hashCode());
        String $accessControlAllowCredentials = this.getAccessControlAllowCredentials();
        result = result * 59 + ($accessControlAllowCredentials == null ? 43 : $accessControlAllowCredentials.hashCode());
        return result;
    }

    public String toString() {
        return "CORSPolicy(accessControlAllowOrigin=" + this.getAccessControlAllowOrigin() + ", accessControlAllowMethods=" + this.getAccessControlAllowMethods() + ", accessControlAllowHeaders=" + this.getAccessControlAllowHeaders() + ", accessControlAllowCredentials=" + this.getAccessControlAllowCredentials() + ")";
    }
}

