/*
 * Decompiled with CFR 0.152.
 */
package ru.hixon.switchexhaustivenesschecker;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import ru.hixon.switchexhaustivenesschecker.AnalyzeTaskListener;
import ru.hixon.switchexhaustivenesschecker.SwitchExhaustive;
import ru.hixon.switchexhaustivenesschecker.TestMethodTreePathScanner;

public class SwitchExhaustiveCheckerProcessor
extends AbstractProcessor {
    private final AnalyzeTaskListener analyzeTaskListener = new AnalyzeTaskListener(this);
    private final Map<Name, Boolean> remainingTypeElementNames = new HashMap<Name, Boolean>();
    private final Map<Name, Set<MethodTree>> annotatedMethodsInClasses = new HashMap<Name, Set<MethodTree>>();
    private final Map<Name, TypeElement> nameToTypeElement = new HashMap<Name, TypeElement>();
    private Messager messager;
    private Trees trees;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.trees = Trees.instance(processingEnv);
        JavacTask.instance(processingEnv).addTaskListener(this.analyzeTaskListener);
    }

    void handleAnalyzedType(TypeElement eventTypeElement, CompilationUnitTree compilationUnit) {
        Name eventClassName = eventTypeElement.getQualifiedName();
        Boolean needProcessAllMethodsInClass = this.remainingTypeElementNames.remove(eventClassName);
        TypeElement typeElement = eventTypeElement;
        if (needProcessAllMethodsInClass == null) {
            Map.Entry<Name, Boolean> entry = this.findNeedProcessAllMethodsInClassForNestedClass(eventClassName.toString());
            if (entry == null) {
                return;
            }
            needProcessAllMethodsInClass = entry.getValue();
            eventClassName = entry.getKey();
            typeElement = this.nameToTypeElement.getOrDefault(eventClassName, eventTypeElement);
        }
        TreePath treePath = this.trees.getPath(typeElement);
        Set<MethodTree> methodsForAnalysis = this.annotatedMethodsInClasses.remove(eventClassName);
        if (needProcessAllMethodsInClass.booleanValue()) {
            methodsForAnalysis = null;
        }
        this.processType(this.trees, typeElement, treePath, methodsForAnalysis, compilationUnit);
    }

    private Map.Entry<Name, Boolean> findNeedProcessAllMethodsInClassForNestedClass(String prefixClassName) {
        Iterator<Map.Entry<Name, Boolean>> iter = this.remainingTypeElementNames.entrySet().iterator();
        while (iter.hasNext()) {
            String suffixClassName;
            Map.Entry<Name, Boolean> entry = iter.next();
            String fullClassName = entry.getKey().toString();
            if (!fullClassName.startsWith(prefixClassName) || (suffixClassName = fullClassName.substring(prefixClassName.length())).isEmpty() || suffixClassName.charAt(0) != '.') continue;
            boolean found = true;
            for (int i = 1; i < suffixClassName.length(); ++i) {
                if (Character.isJavaIdentifierPart(suffixClassName.charAt(i))) continue;
                found = false;
                break;
            }
            if (!found) continue;
            iter.remove();
            return entry;
        }
        return null;
    }

    private void processType(Trees trees, TypeElement typeElement, TreePath treePath, Set<MethodTree> methodsForAnalysis, CompilationUnitTree compilationUnit) {
        CompilationUnitTree compilationUnitTree = treePath == null ? compilationUnit : treePath.getCompilationUnit();
        TestMethodTreePathScanner treePathScanner = new TestMethodTreePathScanner(trees, compilationUnitTree, this.messager, methodsForAnalysis, typeElement.getQualifiedName(), this.nameToTypeElement);
        treePathScanner.scan(compilationUnitTree, null);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(SwitchExhaustive.class);
        for (Element element : elementsAnnotatedWith) {
            try {
                switch (element.getKind()) {
                    case METHOD: 
                    case CONSTRUCTOR: {
                        TypeElement declaringClass = (TypeElement)element.getEnclosingElement();
                        Name className = declaringClass.getQualifiedName();
                        this.remainingTypeElementNames.putIfAbsent(className, false);
                        this.nameToTypeElement.putIfAbsent(className, declaringClass);
                        this.annotatedMethodsInClasses.computeIfAbsent(className, ignored -> new HashSet()).add((MethodTree)this.trees.getTree(element));
                        break;
                    }
                    case CLASS: {
                        TypeElement currenTypeElement = ElementFilter.typesIn(Collections.singletonList(element)).get(0);
                        Name currentClassName = currenTypeElement.getQualifiedName();
                        this.remainingTypeElementNames.put(currentClassName, true);
                        this.nameToTypeElement.putIfAbsent(currentClassName, currenTypeElement);
                    }
                }
            }
            catch (Exception e) {
                this.error(element, "got an error while process(): " + SwitchExhaustiveCheckerProcessor.getExceptionStackTrace(e) + " " + e.getMessage(), new Object[0]);
                throw new RuntimeException("got an error while process()", e);
            }
        }
        return true;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(SwitchExhaustive.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void error(Element element, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), element);
    }

    private static String getExceptionStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

