/*
 * Decompiled with CFR 0.152.
 */
package ru.hixon.switchexhaustivenesschecker;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

final class TestMethodTreePathScanner
extends TreePathScanner<Void, Void> {
    private final Trees trees;
    private final CompilationUnitTree compilationUnitTree;
    private final Messager messager;
    private final Set<MethodTree> methodsForAnalysis;
    private final Name classForAnalysis;
    private final Map<Name, TypeElement> classesForAnalysis;

    TestMethodTreePathScanner(Trees trees, CompilationUnitTree compilationUnitTree, Messager messager, Set<MethodTree> methodsForAnalysis, Name classForAnalysis, Map<Name, TypeElement> classesForAnalysis) {
        this.trees = trees;
        this.compilationUnitTree = compilationUnitTree;
        this.messager = messager;
        this.methodsForAnalysis = methodsForAnalysis;
        this.classForAnalysis = classForAnalysis;
        this.classesForAnalysis = classesForAnalysis;
    }

    @Override
    public Void visitMethod(MethodTree methodTree, Void unused) {
        if (this.isAnalyseOnlySpecificMethodsInClass() && !this.methodsForAnalysis.remove(methodTree)) {
            return null;
        }
        if (!this.canProcessThisClass(methodTree)) {
            return null;
        }
        for (StatementTree statementTree : methodTree.getBody().getStatements()) {
            if (statementTree.getKind() != Tree.Kind.SWITCH) continue;
            this.processCurrentSwitchStatement((SwitchTree)statementTree, methodTree.getName());
        }
        return null;
    }

    private boolean canProcessThisClass(MethodTree methodTree) {
        TreePath treePath = TreePath.getPath(this.compilationUnitTree, (Tree)methodTree);
        String parentClassNameForMethod = this.trees.getElement(treePath).getEnclosingElement().toString();
        boolean continueProcessing = false;
        for (Name className : this.classesForAnalysis.keySet()) {
            String cls = className.toString();
            if (!parentClassNameForMethod.equals(cls) && !parentClassNameForMethod.startsWith(cls + '.')) continue;
            continueProcessing = true;
        }
        return continueProcessing;
    }

    private void processCurrentSwitchStatement(SwitchTree statementTree, Name currentMethodName) {
        ExpressionTree switchTreeExpression = statementTree.getExpression();
        TreePath treePath = TreePath.getPath(this.compilationUnitTree, (Tree)switchTreeExpression);
        TypeMirror typeMirror = this.trees.getTypeMirror(treePath);
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return;
        }
        Element enumElement = ((DeclaredType)typeMirror).asElement();
        if (enumElement.getKind() != ElementKind.ENUM) {
            return;
        }
        List<Element> enumValues = this.getEnumValuesForGivenEnum(enumElement);
        int numberOfNonDefaultSwitchCases = this.getNumberOfNonDefaultSwitchCases(statementTree);
        if (numberOfNonDefaultSwitchCases != enumValues.size()) {
            String methodNameAsString = currentMethodName.toString();
            if (methodNameAsString.equals("<init>")) {
                methodNameAsString = this.classForAnalysis + "()";
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Some switch branches in class: " + this.classForAnalysis + ", method: " + methodNameAsString + " are not covered", this.trees.getElement(treePath));
        }
    }

    private int getNumberOfNonDefaultSwitchCases(SwitchTree switchTree) {
        int count = 0;
        for (CaseTree caseTree : switchTree.getCases()) {
            if (caseTree.getExpression() == null) continue;
            ++count;
        }
        return count;
    }

    private List<Element> getEnumValuesForGivenEnum(Element enumElement) {
        ArrayList<Element> enumConstants = new ArrayList<Element>();
        for (Element element : enumElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            enumConstants.add(element);
        }
        return enumConstants;
    }

    private boolean isAnalyseOnlySpecificMethodsInClass() {
        return this.methodsForAnalysis != null;
    }
}

