/*
 * Decompiled with CFR 0.152.
 */
package ru.hixon.switchexhaustivenesschecker;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

final class TestMethodTreePathScanner
extends TreePathScanner<Void, Void> {
    private final Trees trees;
    private final CompilationUnitTree compilationUnitTree;
    private final Messager messager;
    private final Set<MethodTree> methodsForAnalysis;
    private final Name classForAnalysis;
    private final Map<Name, TypeElement> classesForAnalysis;

    TestMethodTreePathScanner(Trees trees, CompilationUnitTree compilationUnitTree, Messager messager, Set<MethodTree> methodsForAnalysis, Name classForAnalysis, Map<Name, TypeElement> classesForAnalysis) {
        this.trees = trees;
        this.compilationUnitTree = compilationUnitTree;
        this.messager = messager;
        this.methodsForAnalysis = methodsForAnalysis;
        this.classForAnalysis = classForAnalysis;
        this.classesForAnalysis = classesForAnalysis;
    }

    @Override
    public Void visitMethod(MethodTree methodTree, Void unused) {
        if (this.isAnalyseOnlySpecificMethodsInClass() && !this.methodsForAnalysis.remove(methodTree)) {
            return null;
        }
        if (!this.canProcessThisClass(methodTree)) {
            return null;
        }
        for (StatementTree statementTree : methodTree.getBody().getStatements()) {
            if (statementTree.getKind() != Tree.Kind.SWITCH) continue;
            this.processCurrentSwitchStatement((SwitchTree)statementTree, methodTree.getName());
        }
        return null;
    }

    private boolean canProcessThisClass(MethodTree methodTree) {
        TreePath treePath = TreePath.getPath(this.compilationUnitTree, (Tree)methodTree);
        String parentClassNameForMethod = this.trees.getElement(treePath).getEnclosingElement().toString();
        boolean continueProcessing = false;
        for (Name className : this.classesForAnalysis.keySet()) {
            String cls = className.toString();
            if (!parentClassNameForMethod.equals(cls) && !parentClassNameForMethod.startsWith(cls + '.')) continue;
            continueProcessing = true;
        }
        return continueProcessing;
    }

    private void processCurrentSwitchStatement(SwitchTree statementTree, Name currentMethodName) {
        ExpressionTree switchTreeExpression = statementTree.getExpression();
        TreePath treePath = TreePath.getPath(this.compilationUnitTree, (Tree)switchTreeExpression);
        TypeMirror typeMirror = this.trees.getTypeMirror(treePath);
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return;
        }
        Element enumElement = ((DeclaredType)typeMirror).asElement();
        if (enumElement.getKind() != ElementKind.ENUM) {
            return;
        }
        Set<String> enumValues = this.getEnumValuesForGivenEnum(enumElement);
        Set<String> nonDefaultCoveredEnums = this.getNonDefaultCoveredSwitchCases(statementTree);
        if (nonDefaultCoveredEnums.size() != enumValues.size()) {
            String methodOrConstructorStr = "method";
            String methodOrConstructorNameAsString = currentMethodName.toString();
            if (methodOrConstructorNameAsString.equals("<init>")) {
                methodOrConstructorStr = "constructor";
                methodOrConstructorNameAsString = this.classForAnalysis + "()";
            }
            String nonCoveredEnumsAsStr = enumValues.stream().filter(e -> !nonDefaultCoveredEnums.contains(e)).collect(Collectors.joining(", "));
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Switch branches: [" + nonCoveredEnumsAsStr + "] in class: [" + this.classForAnalysis + "], " + methodOrConstructorStr + ": [" + methodOrConstructorNameAsString + "] are not covered", this.trees.getElement(treePath));
        }
    }

    private Set<String> getNonDefaultCoveredSwitchCases(SwitchTree switchTree) {
        HashSet<String> coveredEnums = new HashSet<String>();
        for (CaseTree caseTree : switchTree.getCases()) {
            if (caseTree.getExpression() == null) continue;
            coveredEnums.add(caseTree.getExpression().toString());
        }
        return coveredEnums;
    }

    private Set<String> getEnumValuesForGivenEnum(Element enumElement) {
        HashSet<String> enumConstants = new HashSet<String>();
        for (Element element : enumElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            enumConstants.add(element.getSimpleName().toString());
        }
        return enumConstants;
    }

    private boolean isAnalyseOnlySpecificMethodsInClass() {
        return this.methodsForAnalysis != null;
    }
}

