/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package ru.ilb.adjustdate.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * Класс с конверторами даты
 *
 * @author klimovskih
 */
public class DateUtilsConverter {

    /**
     * Конвертер LocalDate в Date
     *
     * @param localDate
     * @return Date
     */
    public static Date asDate(LocalDate localDate) {
        return localDate != null ? Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    /**
     * Конвертер LocalDateTime в Date
     *
     * @param localDateTime
     * @return Date
     */
    public static Date asDate(LocalDateTime localDateTime) {
        return localDateTime != null ? Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    /**
     * Конвертер Date в LocalDate
     *
     * @param date
     * @return LocalDate
     */
    public static LocalDate asLocalDate(Date date) {
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate() : null;
    }

    /**
     * Конвертер Date в LocalDateTime
     *
     * @param date
     * @return LocalDateTime
     */
    public static LocalDateTime asLocalDateTime(Date date) {
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime() : null;
    }

    /**
     * Конвертер LocalDate в String (по умолчанию формат yyyy-MM-dd)
     *
     * @param date
     * @param format Например: yyyy-MM-dd
     * @return String
     */
    public static String toString(LocalDate date, String format) {
        if (format == null) {
            format = "yyyy-MM-dd";
        }
        return DateTimeFormatter.ofPattern(format).format(date);
    }

    /**
     * Конвертер LocalDateTime в String (по умолчанию формат yyyy-MM-dd HH:mm:ss)
     *
     * @param date
     * @param format Например: yyyy-MM-dd HH:mm:ss
     * @return String
     */
    public static String toString(LocalDateTime date, String format) {
        if (format == null) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        return DateTimeFormatter.ofPattern(format).format(date);
    }

    /**
     * Конвертер String в LocalDate
     *
     * @param date
     * @param format
     * @return LocalDate
     */
    public static LocalDate asLocalDate(String date, String format) {
        return LocalDate.parse(date, DateTimeFormatter.ofPattern(format));
    }

}
