/*
 * DaysadjustmentImpl.java
 *
 * Created on 7 Май 2007 г., 12:34
 *
 */
package ru.ilb.util.date.daysadjustment;

import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBException;
import org.joda.time.DateTime;
//import ru.ilb.meta.MetaFactory;
import ru.ilb.meta.common.daysadjustment.Daysadjustment;
import ru.ilb.meta.common.daysadjustment.Holiday;
import ru.ilb.meta.common.daysadjustment.Unwantedday;
import ru.ilb.meta.common.daysadjustment.Weekend;

/**
 *
 * @author Alexander Soklakov
 */
public class DaysadjustmentImpl extends Daysadjustment {

    /**
     * Creates a new instance of DaysadjustmentImpl
     */
    public DaysadjustmentImpl(Daysadjustment da) throws IllegalArgumentException {

        // лимит массива дат - +30 лет от текущей даты
        Calendar curr30 = Calendar.getInstance();
        curr30.add(Calendar.YEAR, 30);

        for (Holiday hd : da.getHoliday()) {
            Calendar[] c = new HolidayImpl(hd).getDates(curr30);
            for (int i = 0; i < c.length; ++i) {
                this.getHoliday().add(new HolidayImpl((GregorianCalendar) c[i]));
            }
        }

        for (Weekend we : da.getWeekend()) {
            Calendar[] c = new WeekendImpl(we).getDates(curr30);
            for (int i = 0; i < c.length; ++i) {
                // переносим выходные, пришедшиеся на праздники
                while (isFreeDay(c[i])) {
                    c[i].add(Calendar.DAY_OF_MONTH, 1);
                }
                this.getWeekend().add(new WeekendImpl((GregorianCalendar) c[i]));
            }
        }
        for (Unwantedday ud : da.getUnwantedday()) {
            this.getUnwantedday().add(new UnwanteddayImpl(ud));
        }

    }

//    public static DaysadjustmentImpl getDefaultInstance() throws JAXBException, IOException, IllegalArgumentException {
//        return new DaysadjustmentImpl((Daysadjustment) MetaFactory.newInstance(Daysadjustment.class));
//    }
//
//    public static DaysadjustmentImpl getCreditsInstance() throws JAXBException, IOException, IllegalArgumentException {
//        return new DaysadjustmentImpl((Daysadjustment) MetaFactory.newInstance(Daysadjustment.class, "data/daysadjustment/daysadjustment_cr.xml"));
//    }

    /**
     * Попадает ли дата на выходной день
     *
     * @return true - выходной день<br/>false - не выходной день
     */
    public boolean isWeekend(DateTime datetime) {
        return isWeekend(datetime.toGregorianCalendar());

    }

    /**
     * Попадает ли дата на выходной день
     *
     * @return true - выходной день<br/>false - не выходной день
     */
    public boolean isWeekend(Calendar gc) {
        // проверка даты на выходной
        if (gc != null) {
            for (Weekend we : this.getWeekend()) {
                if (we.getRfc3339Value() != null) {
                    if (((WeekendImpl) we).getDateEntity().inRange(gc)) {
                        return true;
                    }
                } else if (we.getDateValue() != null) {
                    if (we.getDateValue().get(Calendar.YEAR) == gc.get(Calendar.YEAR)
                            && we.getDateValue().get(Calendar.MONTH) == gc.get(Calendar.MONTH)
                            && we.getDateValue().get(Calendar.DAY_OF_MONTH) == gc.get(Calendar.DAY_OF_MONTH)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
     * Попадает ли дата на праздничный день
     *
     * @return true - выходной день<br/>false - не выходной день
     */
    public boolean isHoliday(DateTime datetime) {
        return isHoliday(datetime.toGregorianCalendar());
    }

    /**
     * Попадает ли дата на праздничный день
     *
     * @return true - выходной день<br/>false - не выходной день
     */
    public boolean isHoliday(Calendar gc) {
        // проверка даты на выходной
        if (gc != null) {
            for (Holiday hd : this.getHoliday()) {
                if (hd.getRfc3339Value() != null) {
                    if (((HolidayImpl) hd).getDateEntity().inRange(gc)) {
                        return true;
                    }
                } else if (hd.getDateValue() != null) {
                    if (hd.getDateValue().get(Calendar.YEAR) == gc.get(Calendar.YEAR)
                            && hd.getDateValue().get(Calendar.MONTH) == gc.get(Calendar.MONTH)
                            && hd.getDateValue().get(Calendar.DAY_OF_MONTH) == gc.get(Calendar.DAY_OF_MONTH)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
     * Является ли дата нежелательной
     *
     * @return true - нежелательная дата<br/>false - не нежелательная дата
     */
    public boolean isUnwantedday(DateTime datetime) {
        return isUnwantedday(datetime.toGregorianCalendar());

    }

    /**
     * Является ли дата нежелательной
     *
     * @return true - нежелательная дата<br/>false - не нежелательная дата
     */
    public boolean isUnwantedday(Calendar gc) {
        if (gc != null) {
            for (Unwantedday ud : this.getUnwantedday()) {
                if (ud.getRfc3339Value() != null) {
                    if (((UnwanteddayImpl) ud).getDateEntity().inRange(gc)) {
                        return true;
                    }
                } else if (ud.getDateValue() != null) {
                    if (ud.getDateValue().get(Calendar.YEAR) == gc.get(Calendar.YEAR)
                            && ud.getDateValue().get(Calendar.MONTH) == gc.get(Calendar.MONTH)
                            && ud.getDateValue().get(Calendar.DAY_OF_MONTH) == gc.get(Calendar.DAY_OF_MONTH)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
     * Является ли дата нежелательной, попадает ли на выходной
     *
     * @return true - нежелательная дата или выходной<br/>false - не нежелательная дата, не выходной
     */
    public boolean isFreeDay(Calendar gc) {
        return (isHoliday(gc) || isUnwantedday(gc) || isWeekend(gc));
    }
}
