/*
 * HolidayImpl.java
 *
 * Created on 11 Май 2007 г., 14:17
 *
 */
package ru.ilb.util.date.daysadjustment;

import java.util.Calendar;
import java.util.GregorianCalendar;
import ru.ilb.common.rfc3339.DateEntity;
import ru.ilb.meta.common.daysadjustment.Holiday;

/**
 *
 * @author Alexander Soklakov
 */
public class HolidayImpl extends Holiday {

    private DateEntity _value;

    /**
     * Creates a new instance of HolidayImpl
     */
    public HolidayImpl(Holiday hd) throws IllegalArgumentException {
        if (hd.getRfc3339Value() != null) {
            this.setRfc3339Value(hd.getRfc3339Value());
            _value = DateEntity.parse(hd.getRfc3339Value(), DateEntity.PRECISION_DAY);
        } else if (hd.getDateValue() != null) {
            this.setDateValue(hd.getDateValue());
            _value = new DateEntity(hd.getDateValue(), DateEntity.PRECISION_DAY);
        }
    }

    public HolidayImpl(String rfc3339) throws IllegalArgumentException {
        this.setRfc3339Value(rfc3339);
        _value = DateEntity.parse(rfc3339, DateEntity.PRECISION_DAY);
    }

    public HolidayImpl(GregorianCalendar calendar) {
        this.setDateValue(calendar);
        _value = new DateEntity(calendar, DateEntity.PRECISION_DAY);
    }

    public DateEntity getDateEntity() {
        return this._value;
    }

    public Calendar[] getDates(final Calendar limit) {
        return _value.getDates(limit);
    }
}
