/*
 * UnwanteddayImpl.java
 *
 * Created on 11 Май 2007 г., 14:29
 *
 */
package ru.ilb.util.date.daysadjustment;

import java.util.Calendar;
import java.util.GregorianCalendar;
import ru.ilb.common.rfc3339.DateEntity;
import ru.ilb.meta.common.daysadjustment.Unwantedday;

/**
 *
 * @author Alexander Soklakov
 */
public class UnwanteddayImpl extends Unwantedday {

    private DateEntity _value;

    /**
     * Creates a new instance of UnwanteddayImpl
     */
    public UnwanteddayImpl(Unwantedday ud) throws IllegalArgumentException {
        if (ud.getRfc3339Value() != null) {
            this.setRfc3339Value(ud.getRfc3339Value());
            _value = DateEntity.parse(ud.getRfc3339Value(), DateEntity.PRECISION_DAY);
        } else if (ud.getDateValue() != null) {
            this.setDateValue(ud.getDateValue());
            _value = new DateEntity(ud.getDateValue(), DateEntity.PRECISION_DAY);
        }
    }

    public UnwanteddayImpl(String rfc3339) throws IllegalArgumentException {
        this.setRfc3339Value(rfc3339);
        _value = DateEntity.parse(rfc3339, DateEntity.PRECISION_DAY);
    }

    public UnwanteddayImpl(GregorianCalendar calendar) {
        this.setDateValue(calendar);
        _value = new DateEntity(calendar, DateEntity.PRECISION_DAY);
    }

    public DateEntity getDateEntity() {
        return this._value;
    }

    public Calendar[] getDates(final Calendar limit) {
        return _value.getDates(limit);
    }

}
