/*
 * WeekendImpl.java
 *
 * Created on 12 Ноябрь 2007 г., 10:50
 *
 */
package ru.ilb.util.date.daysadjustment;

import java.util.Calendar;
import java.util.GregorianCalendar;
import ru.ilb.common.rfc3339.DateEntity;
import ru.ilb.meta.common.daysadjustment.Weekend;

/**
 *
 * @author Alexander Soklakov
 */
public class WeekendImpl extends Weekend {

    private DateEntity _value;

    /**
     * Creates a new instance of WeekendImpl
     */
    public WeekendImpl(Weekend we) throws IllegalArgumentException {
        if (we.getRfc3339Value() != null) {
            this.setRfc3339Value(we.getRfc3339Value());
            _value = DateEntity.parse(we.getRfc3339Value(), DateEntity.PRECISION_DAY);
        } else if (we.getDateValue() != null) {
            this.setDateValue(we.getDateValue());
            _value = new DateEntity(we.getDateValue(), DateEntity.PRECISION_DAY);
        }
    }

    public WeekendImpl(String rfc3339) throws IllegalArgumentException {
        this.setRfc3339Value(rfc3339);
        _value = DateEntity.parse(rfc3339, DateEntity.PRECISION_DAY);
    }

    public WeekendImpl(GregorianCalendar calendar) {
        this.setDateValue(calendar);
        _value = new DateEntity(calendar, DateEntity.PRECISION_DAY);
    }

    public DateEntity getDateEntity() {
        return this._value;
    }

    public Calendar[] getDates(final Calendar limit) {
        return _value.getDates(limit);
    }

}
