/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.adjustdate.utils;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.LocalDate;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.joda.time.DateTime;
import org.joda.time.MutableDateTime;
import org.xml.sax.InputSource;
import ru.ilb.adjustdate.utils.DateUtilsConverter;
import ru.ilb.meta.common.daysadjustment.Daysadjustment;
import ru.ilb.util.date.daysadjustment.DaysadjustmentImpl;

@Named
public class AdjustDate {
    private final URI daysadjustmentURI;
    private static DaysadjustmentImpl daysAdjustmentImpl = null;

    public AdjustDate(URI daysadjustmentURI) {
        this.daysadjustmentURI = daysadjustmentURI;
    }

    public LocalDate adjust(LocalDate localDate, boolean sameMonth) {
        DaysadjustmentImpl adjustmentCalendar = this.getDaysAdjustmentImpl();
        int month = localDate.getMonthValue();
        MutableDateTime mdt = new DateTime((Object)DateUtilsConverter.asDate(localDate)).toMutableDateTime();
        while ((adjustmentCalendar.isWeekend(mdt.toDateTime()) || adjustmentCalendar.isHoliday(mdt.toDateTime()) || adjustmentCalendar.isUnwantedday(mdt.toDateTime())) && (!sameMonth || month == mdt.getMonthOfYear())) {
            mdt.addDays(1);
        }
        if (sameMonth && month != mdt.getMonthOfYear()) {
            mdt.addDays(-1);
            while (adjustmentCalendar.isWeekend(mdt.toDateTime()) || adjustmentCalendar.isHoliday(mdt.toDateTime()) || adjustmentCalendar.isUnwantedday(mdt.toDateTime()) && month == mdt.getMonthOfYear()) {
                mdt.addDays(-1);
            }
        }
        return DateUtilsConverter.asLocalDate(mdt.toDate());
    }

    private DaysadjustmentImpl getDaysAdjustmentImpl() {
        if (daysAdjustmentImpl == null) {
            Daysadjustment da;
            try {
                da = this.getDaysadjustment();
            }
            catch (JAXBException ex) {
                throw new RuntimeException("Can't instantiate DaysadjustmentImpl", ex);
            }
            catch (IllegalArgumentException | MalformedURLException ex) {
                throw new RuntimeException("Can't instantiate DaysadjustmentImpl, wrong arguments", ex);
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't instantiate DaysadjustmentImpl, wrong arguments", ex);
            }
            daysAdjustmentImpl = new DaysadjustmentImpl(da);
        }
        return daysAdjustmentImpl;
    }

    private Daysadjustment getDaysadjustment() throws JAXBException, MalformedURLException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Daysadjustment.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        URL url = this.daysadjustmentURI.toURL();
        InputSource is = new InputSource(url.toExternalForm());
        is.setEncoding("UTF-8");
        Daysadjustment da = (Daysadjustment)jaxbUnmarshaller.unmarshal(url);
        return da;
    }
}

