/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.adjustdate.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateUtilsConverter {
    public static Date asDate(LocalDate localDate) {
        return localDate != null ? Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return localDateTime != null ? Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()) : null;
    }

    public static LocalDate asLocalDate(Date date) {
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate() : null;
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return date != null ? Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime() : null;
    }

    public static String toString(LocalDate date, String format) {
        if (format == null) {
            format = "yyyy-MM-dd";
        }
        return DateTimeFormatter.ofPattern(format).format(date);
    }

    public static String toString(LocalDateTime date, String format) {
        if (format == null) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        return DateTimeFormatter.ofPattern(format).format(date);
    }

    public static LocalDate asLocalDate(String date, String format) {
        return LocalDate.parse(date, DateTimeFormatter.ofPattern(format));
    }
}

