/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.rfc3339;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import org.joda.time.DateTime;
import org.joda.time.Period;

public class DateEntity {
    public static int PRECISION_DAY = 0;
    public static int PRECISION_HOUR_OF_DAY = 1;
    public static int PRECISION_MINUTE = 2;
    public static int PRECISION_SECOND = 3;
    public static int PRECISION_MILLISECOND = 4;
    public static int[][] calendar_precisions = new int[][]{{11, 12, 13, 14}, {12, 13, 14}, {13, 14}, {14}, new int[0]};
    private DateTime START = null;
    private DateTime END = null;
    private Period PERIOD = null;
    private int PRECISION = PRECISION_MILLISECOND;

    private DateEntity() {
    }

    public DateEntity(Calendar c, Integer precision) {
        if (precision != null) {
            this.PRECISION = precision;
        }
        this.START = new DateTime((Object)this.round(c));
    }

    public DateEntity(String str, Integer precision) throws IllegalArgumentException {
        if (precision != null) {
            this.PRECISION = precision;
        }
        try {
            this.START = this.round(new DateTime((Object)str));
        }
        catch (IllegalArgumentException ex1) {
            String[] tmp = str.split("/");
            if (tmp.length == 3) {
                this.START = this.round(new DateTime((Object)tmp[0]));
                this.PERIOD = new Period((Object)tmp[1]);
                this.END = this.round(new DateTime((Object)tmp[2]));
            }
            if (tmp.length == 2) {
                if (!str.startsWith("P")) {
                    this.START = this.round(new DateTime((Object)tmp[0]));
                    this.PERIOD = new Period((Object)tmp[1]);
                } else {
                    this.PERIOD = new Period((Object)tmp[0]);
                    this.END = this.round(new DateTime((Object)tmp[1]));
                }
            }
            this.PERIOD = new Period((Object)tmp[0]);
        }
    }

    public static DateEntity parse(String str, Integer precision) throws IllegalArgumentException {
        return new DateEntity(str, precision);
    }

    public boolean haveStart() {
        return this.START != null;
    }

    public boolean havePeriod() {
        return this.PERIOD != null;
    }

    public boolean haveEnd() {
        return this.END != null;
    }

    public DateTime getStart() {
        return this.START;
    }

    public Period getPeriod() {
        return this.PERIOD;
    }

    public DateTime getEnd() {
        return this.END;
    }

    public int getPrecision() {
        return this.PRECISION;
    }

    public String toString() {
        String res = this.haveStart() ? this.START.toString() : "";
        res = res + (this.havePeriod() ? (res.equals("") ? "" : "/") + this.PERIOD.toString() : "");
        res = res + (this.haveEnd() ? (res.equals("") ? "" : "/") + this.END.toString() : "");
        return res;
    }

    public Calendar[] getDates(Calendar limit) {
        Calendar curr = this.round(Calendar.getInstance());
        Calendar lim = limit == null ? (Calendar)curr.clone() : this.round(limit);
        ArrayList<Calendar> dates = new ArrayList<Calendar>();
        if (!this.havePeriod()) {
            if (this.haveStart()) {
                dates.add((Calendar)this.START.toGregorianCalendar().clone());
            }
        } else {
            Calendar end;
            Calendar start;
            boolean use_next = true;
            if (this.haveStart() && this.haveEnd()) {
                start = (Calendar)this.START.toGregorianCalendar().clone();
                end = (Calendar)this.END.toGregorianCalendar().clone();
            } else if (this.haveStart() && !this.haveEnd()) {
                start = (Calendar)this.START.toGregorianCalendar().clone();
                end = lim;
            } else if (!this.haveStart() && this.haveEnd()) {
                start = lim;
                end = (Calendar)this.END.toGregorianCalendar().clone();
                use_next = false;
            } else if (lim.after(curr)) {
                start = curr;
                end = lim;
            } else {
                start = lim;
                end = curr;
                use_next = false;
            }
            int i = 0;
            if (use_next) {
                Calendar gc = (Calendar)start.clone();
                while (gc.compareTo(end) <= 0) {
                    dates.add(gc);
                    gc = this.next(start, ++i);
                }
            } else {
                Calendar gc = (Calendar)end.clone();
                while (gc.compareTo(start) >= 0) {
                    dates.add(gc);
                    gc = this.previous(end, ++i);
                }
            }
        }
        Object[] c = dates.toArray(new Calendar[dates.size()]);
        Arrays.sort(c);
        return c;
    }

    public boolean inRange(Calendar date) {
        Calendar[] da = this.getDates(date);
        for (int i = 0; i < da.length; ++i) {
            if (da[i].compareTo(date) != 0) continue;
            return true;
        }
        return false;
    }

    public Calendar next(Calendar date, int i) {
        if (this.PERIOD == null) {
            return null;
        }
        Calendar gc = (Calendar)date.clone();
        gc.add(14, this.PERIOD.getMillis() * i);
        gc.add(13, this.PERIOD.getSeconds() * i);
        gc.add(12, this.PERIOD.getMinutes() * i);
        gc.add(11, this.PERIOD.getHours() * i);
        gc.add(5, this.PERIOD.getDays() * i);
        gc.add(2, this.PERIOD.getMonths() * i);
        gc.add(1, this.PERIOD.getYears() * i);
        gc.add(3, this.PERIOD.getWeeks() * i);
        return gc;
    }

    public Calendar previous(Calendar date, int i) {
        return this.next(date, -i);
    }

    public static Calendar round(Calendar calendar, Integer precision) {
        Calendar c = (Calendar)calendar.clone();
        if (precision != null) {
            for (int i = 0; i < calendar_precisions[precision].length; ++i) {
                c.set(calendar_precisions[precision][i], 0);
            }
        }
        return c;
    }

    private Calendar round(Calendar calendar) {
        return DateEntity.round(calendar, this.PRECISION);
    }

    private DateTime round(DateTime dt) {
        return new DateTime((Object)DateEntity.round(dt.toGregorianCalendar(), this.PRECISION));
    }
}

