/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.rfc3339.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class DateConverter {
    public static GregorianCalendar gregorian_calendar = new GregorianCalendar();
    public static DatatypeFactory datatype_factory = null;

    public static String makePeriod(String startDate, String duration, String endDate) {
        String res = startDate;
        if (!duration.equals("")) {
            res = res.equals("") ? duration : res + "/" + duration;
        }
        if (!endDate.equals("")) {
            res = res.equals("") ? endDate : res + "/" + endDate;
        }
        return res;
    }

    public static String getMsFromDate(String iso_date_time) {
        return "" + new DateTime((Object)iso_date_time).getMillis();
    }

    public static String getMsFromTime(String time) {
        return "" + new DateTime((Object)time).getMillis();
    }

    public static String getMsFromInterval(String period) {
        Interval i = new Interval((ReadableInstant)new DateTime((Object)Calendar.getInstance()), (ReadablePeriod)new Period((Object)period));
        return "" + (i.getEndMillis() - i.getStartMillis());
    }

    public static String getDateString(long ms) {
        return new DateTime(ms).toString();
    }

    public static String getDateString(String ms) {
        return DateConverter.getDateString(Long.parseLong(ms));
    }

    public static String getDateString(Calendar calendar) {
        return new DateTime((Object)calendar).toString();
    }

    public static String getDateOnlyString(Calendar calendar) {
        DateTime dt = new DateTime((Object)calendar);
        DateTimeFormatter fmt = ISODateTimeFormat.date();
        return fmt.print((ReadableInstant)dt);
    }

    public static String getTimeString(long ms) {
        DateTimeFormatterBuilder fb = new DateTimeFormatterBuilder().appendHourOfDay(2).appendLiteral(":").appendMinuteOfHour(2).appendLiteral(":").appendSecondOfMinute(2).appendLiteral(".").appendFractionOfSecond(0, 3).appendTimeZoneOffset("Z", true, 2, 2);
        return new DateTime(ms).toString(fb.toFormatter());
    }

    public static String getTimeString(String ms) {
        return DateConverter.getTimeString(Long.parseLong(ms));
    }

    public static String getIntervalString(String ms) {
        Duration d = new Duration(Long.parseLong(ms));
        return d.toString();
    }

    public static XMLGregorianCalendar newXMLGregorianCalendarInstance(String date) throws DatatypeConfigurationException {
        if (datatype_factory == null) {
            datatype_factory = DatatypeFactory.newInstance();
        }
        return datatype_factory.newXMLGregorianCalendar(date);
    }

    public static XMLGregorianCalendar newXMLGregorianCalendarInstance(Date date) throws DatatypeConfigurationException {
        if (date == null) {
            return null;
        }
        if (gregorian_calendar == null) {
            gregorian_calendar = new GregorianCalendar();
        }
        if (datatype_factory == null) {
            datatype_factory = DatatypeFactory.newInstance();
        }
        gregorian_calendar.setTime(date);
        return datatype_factory.newXMLGregorianCalendar(gregorian_calendar);
    }

    public static GregorianCalendar newGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return gc;
    }
}

